/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.analyzer.gui.tree.TracesTreeModel;
import ch.e2e.builder.analyzer.gui.tree.TreeView;
import ch.e2e.builder.analyzer.gui.tree.menu.DeleteTraceExecuter;
import ch.e2e.builder.analyzer.model.Trace;
import ch.e2e.builder.analyzer.model.TracesRoot;
import ch.e2e.builder.analyzer.model.event.DeleteTraceEvent;
import ch.e2e.builder.analyzer.tree.RefreshTracesTreeEvent;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tree.RefreshTreeEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class TracesTreeView
extends TreeView<TracesRoot> {
    public TracesTreeView(TracesRoot root, Analyzer analyzer) {
        super(root, analyzer);
    }

    @Override
    protected Tree createTree(TracesRoot root) {
        TracesTreeModel treeModel = new TracesTreeModel(root, this.getAnalyzer());
        Tree tree = new Tree((AbstractTreeModel)treeModel);
        tree.setEditable(false);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setSelectWithPopupTrigger(false);
        tree.getSelectionModel().setSelectionMode(1);
        return tree;
    }

    @Override
    public void refreshTree(EventObject event) {
        TestcaseObject parent = ((RefreshTreeEvent)event).getNewSelection();
        if (parent == null) {
            this.setSelectionPath(null);
            this.getTree().refresh();
        } else {
            List expandedRows = this.getTree().getExpandedRows();
            this.getModel().refresh();
            ArrayList<TestcaseObject> pathObjects = new ArrayList<TestcaseObject>();
            while (parent != null) {
                pathObjects.add(0, parent);
                parent = parent.getParent();
            }
            TreePath path = new TreePath(pathObjects.toArray());
            for (TreePath p : expandedRows) {
                if (path.isDescendant(p)) continue;
                this.expandPath(p);
            }
            this.expandPath(path);
            this.setSelectionPath(path);
        }
    }

    @Override
    protected void addEventHandler() {
        this.addDeleteAction(this.getTree().getInputMap(0), this.getTree().getActionMap());
        EventController.register((EventExecuter)new DeleteTraceExecuter(this.getAnalyzer()), DeleteTraceEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                TracesTreeView.this.refreshTree(event);
            }
        }, RefreshTracesTreeEvent.class);
    }

    private void addDeleteAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "analyzer.traces.tree.node.delete");
        actionMap.put("analyzer.traces.tree.node.delete", new AbstractAction("analyzer.traces.tree.node.delete"){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath path = TracesTreeView.this.getSelectionPath();
                if (path != null) {
                    Object node = path.getLastPathComponent();
                    switch (TracesTreeView.this.getModel().getType(node)) {
                        case 39: {
                            EventController.fire((EventObject)new DeleteTraceEvent((Object)this, (Trace)node));
                        }
                    }
                }
            }
        });
    }
}

