/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.xsltinterface;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractXSLTError;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.XSLTError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.base.error.XSLTFatalError;
import ch.e2e.builder.base.error.XSLTWarning;
import ch.e2e.builder.base.message.ImportErrorMessage;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.builder.base.message.SendMessageEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.base.tools.Utilities;
import ch.e2e.builder.base.xsltinterface.Logging;
import ch.e2e.builder.base.xsltinterface.XSLTAction;
import ch.e2e.event.EventController;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class XSLTOutput
implements Logging {
    public static final String ERROR = "error";
    public static final String FATAL_ERROR = "fatalError";
    public static final String INFO = "info";
    public static final String WARNING = "warning";
    public static final String WSDL_IMPORT_ERROR = "wsdl.import.error";
    public static final String WSDL_IMPORT_INFO = "wsdl.import.info";
    public static final String WSDL_IMPORT_WARNING = "wsdl.import.warning";
    protected static String module = "E2EBuilder";
    protected static String messageView = "Scheer PAS Builder Messages";
    private static XSLTAction xsltAction;
    private static Map<String, XSLTErrorHandler> xsltErrorHandlerMap;

    protected static XSLTErrorHandler getXsltErrorHandler(String id) {
        if (id == null) {
            return XSLTErrorHandler.getInstance();
        }
        XSLTErrorHandler handler = xsltErrorHandlerMap.get(id);
        if (handler != null) {
            return handler;
        }
        return XSLTErrorHandler.getInstance();
    }

    public static XSLTErrorHandler addXsltErrorHandler(String id) {
        XSLTErrorHandler handler = xsltErrorHandlerMap.get(id);
        if (handler != null) {
            return handler;
        }
        handler = new XSLTErrorHandler();
        xsltErrorHandlerMap.put(id, handler);
        return handler;
    }

    public static void removeXsltErorHandler(String id) {
        xsltErrorHandlerMap.remove(id);
    }

    public static void info(String code, String parameter) {
        XSLTOutput.info(code, Utilities.createParameterMap(parameter));
    }

    protected static void info(String code, Map<String, String> parameterMap) {
        Object source = xsltAction == null ? XSLTOutput.class : xsltAction;
        SendMessageEvent event = new SendMessageEvent(source, code, parameterMap, module, messageView);
        EventController.fire((EventObject)event);
    }

    public static void warning(String code, String location, String parameter) {
        XSLTOutput.warning(code, location, parameter, null);
    }

    public static void warning(String code, String location, String parameter, String taskId) {
        XSLTOutput.warning(code, location, "", parameter, taskId);
    }

    public static void warning(String code, String location, String originalElement, String parameter, String taskId) {
        Map<String, String> parameterMap = Utilities.createParameterMap(parameter);
        BuilderWarning warning = new XSLTWarning(code, parameterMap, location, originalElement);
        warning = XSLTOutput.getXsltErrorHandler(taskId).warning(warning);
        if (warning != null && taskId == null) {
            Object source = xsltAction == null ? XSLTOutput.class : xsltAction;
            EventController.fire((EventObject)new SendWarningEvent(source, warning, module, messageView));
        }
    }

    public static void wsdlImportWarning(String code, String location, String parameter) {
        XSLTOutput.wsdlImportWarning(code, location, parameter, null);
    }

    public static void wsdlImportWarning(String code, String location, String parameter, String taskId) {
        Map<String, String> parameterMap = Utilities.createParameterMap(parameter);
        BuilderWarning warning = new XSLTWarning(code, parameterMap, location);
        warning = XSLTOutput.getXsltErrorHandler(taskId).warning(warning);
        if (warning != null && taskId == null) {
            Object source = xsltAction == null ? XSLTOutput.class : xsltAction;
            EventController.fire((EventObject)new SendWarningEvent(source, new ImportErrorMessage(source, (AbstractXSLTError)((Object)warning), WARNING, module), messageView));
        }
    }

    public static void error(String code, String location, String parameter) {
        XSLTOutput.error(code, location, parameter, null);
    }

    public static void error(String code, String location, String parameter, String taskId) {
        XSLTOutput.error(code, location, "", parameter, taskId);
    }

    public static void error(String code, String location, String originalElement, String parameter, String taskId) {
        Map<String, String> parameterMap = Utilities.createParameterMap(parameter);
        BuilderError error = new XSLTError(code, parameterMap, location, originalElement);
        error = XSLTOutput.getXsltErrorHandler(taskId).error((AbstractBuilderError)error);
        if (error != null && taskId == null) {
            Object source = xsltAction == null ? XSLTOutput.class : xsltAction;
            EventController.fire((EventObject)new SendErrorEvent(source, error, module, messageView));
        }
    }

    public static void wsdlImportError(String code, String location, String parameter) {
        XSLTOutput.wsdlImportError(code, location, parameter, null);
    }

    public static void wsdlImportError(String code, String location, String parameter, String taskId) {
        Map<String, String> parameterMap = Utilities.createParameterMap(parameter);
        BuilderError error = new XSLTError(code, parameterMap, location);
        error = XSLTOutput.getXsltErrorHandler(taskId).error((AbstractBuilderError)error);
        if (error != null && taskId == null) {
            Object source = xsltAction == null ? XSLTOutput.class : xsltAction;
            EventController.fire((EventObject)new SendErrorEvent(source, new ImportErrorMessage(source, (AbstractXSLTError)error, ERROR, module), messageView));
        }
    }

    public static void fatalError(String code, String location, String parameter) {
        XSLTOutput.fatalError(code, location, parameter, null);
    }

    public static void fatalError(String code, String location, String parameter, String taskId) {
        XSLTOutput.fatalError(code, location, "", parameter, taskId);
    }

    public static void fatalError(String code, String location, String originalElement, String parameter, String taskId) {
        Map<String, String> parameterMap = Utilities.createParameterMap(parameter);
        BuilderFatalError error = new XSLTFatalError(code, parameterMap, location, originalElement);
        error = XSLTOutput.getXsltErrorHandler(taskId).fatalError(error);
        if (error != null && taskId == null) {
            Object source = xsltAction == null ? XSLTOutput.class : xsltAction;
            EventController.fire((EventObject)new SendFatalErrorEvent(source, error, module, messageView));
        }
    }

    public static void log(String message) {
        logger.info(message);
    }

    public static void sendMessage(String code, String type, String umlLocation, String parameter) {
        XSLTOutput.sendMessage(code, type, umlLocation, parameter, null);
    }

    public static void sendMessage(String code, String type, String umlLocation, String parameter, String taskId) {
        XSLTOutput.sendMessage(code, type, umlLocation, "", parameter, taskId);
    }

    public static void sendMessage(String code, String type, String umlLocation, String originalElement, String parameter, String taskId) {
        if (type.equals(INFO)) {
            XSLTOutput.info(code, Utilities.createParameterMap(parameter));
        } else if (type.equals(WSDL_IMPORT_INFO)) {
            XSLTOutput.info(code, Utilities.createParameterMap(parameter));
        } else if (type.equals(WARNING)) {
            XSLTOutput.warning(code, umlLocation, originalElement, parameter, taskId);
        } else if (type.equals(WSDL_IMPORT_WARNING)) {
            XSLTOutput.wsdlImportWarning(code, umlLocation, parameter, taskId);
        } else if (type.equals(ERROR)) {
            XSLTOutput.error(code, umlLocation, originalElement, parameter, taskId);
        } else if (type.equals(WSDL_IMPORT_ERROR)) {
            XSLTOutput.wsdlImportError(code, umlLocation, parameter, taskId);
        } else if (type.equals(FATAL_ERROR)) {
            XSLTOutput.fatalError(code, umlLocation, originalElement, parameter, taskId);
        }
    }

    public static String getModuleName() {
        return module;
    }

    public static String getMessgeView() {
        return messageView;
    }

    public static XSLTAction getXsltAction() {
        return xsltAction;
    }

    public static void setXsltAction(XSLTAction xsltAction) {
        XSLTOutput.xsltAction = xsltAction;
    }

    protected XSLTOutput() {
    }

    static {
        xsltErrorHandlerMap = new HashMap<String, XSLTErrorHandler>();
    }
}

