/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class LazySupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private final ConcurrentMap<String, T> cache = new ConcurrentHashMap<String, T>();

    public LazySupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        return (T)this.cache.computeIfAbsent("key", k -> this.delegate.get());
    }

    public T getOrElse(T other) {
        T value = this.get();
        return value == null ? other : value;
    }

    public static <T> LazySupplier<T> of(Supplier<T> delegate) {
        return new LazySupplier<T>(delegate);
    }
}

