/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.resource;

import ch.e2e.resource.Translator;
import java.util.Hashtable;
import java.util.Locale;

public class E2EBuilderTranslator {
    private static E2EBuilderTranslator builderTranslator = new E2EBuilderTranslator();
    private Translator translator;
    private Locale locale = Locale.ENGLISH;
    private Hashtable<String, Translator> moduleTranslators;

    private E2EBuilderTranslator() {
        this.translator = new Translator("ch.e2e.builder.base.properties.translations", this.locale, this.getClass().getClassLoader());
        this.moduleTranslators = new Hashtable();
    }

    public static void addTranslations(String moduleName, String[] propertyNames) {
        if (moduleName == null) {
            for (String propertyName : propertyNames) {
                E2EBuilderTranslator.builderTranslator.translator.addMap(propertyName);
            }
        } else {
            Translator moduleTranslator = E2EBuilderTranslator.builderTranslator.moduleTranslators.get(moduleName);
            if (moduleTranslator == null) {
                moduleTranslator = new Translator(E2EBuilderTranslator.builderTranslator.locale, E2EBuilderTranslator.class.getClassLoader());
                E2EBuilderTranslator.builderTranslator.moduleTranslators.put(moduleName, moduleTranslator);
            }
            for (String propertyName : propertyNames) {
                moduleTranslator.addMap(propertyName);
            }
        }
    }

    public static String getTranslation(String key) {
        return E2EBuilderTranslator.builderTranslator.translator.getTranslation(key);
    }

    public static String getTranslation(String key, String defTranslation) {
        return E2EBuilderTranslator.builderTranslator.translator.getTranslation(key, defTranslation);
    }

    public static String getModuleTranslation(String moduleName, String key, String defTranslation) {
        Translator moduleTranslator = moduleName == null ? null : E2EBuilderTranslator.builderTranslator.moduleTranslators.get(moduleName);
        String translation = null;
        if (moduleTranslator != null) {
            translation = moduleTranslator.getTranslation(key);
        }
        if (translation == null) {
            translation = E2EBuilderTranslator.builderTranslator.translator.getTranslation(key, defTranslation);
        }
        return translation;
    }

    public static String getModuleTranslation(String moduleName, String key) {
        Translator moduleTranslator = E2EBuilderTranslator.builderTranslator.moduleTranslators.get(moduleName);
        String translation = null;
        if (moduleTranslator != null) {
            translation = moduleTranslator.getTranslation(key);
        }
        if (translation == null) {
            translation = E2EBuilderTranslator.builderTranslator.translator.getTranslation(key);
        }
        return translation;
    }

    public static Translator getTranslator(String moduleName) {
        Translator translator = E2EBuilderTranslator.builderTranslator.moduleTranslators.get(moduleName);
        return translator == null ? E2EBuilderTranslator.builderTranslator.translator : translator;
    }

    static void addTranslations(String name) {
        E2EBuilderTranslator.builderTranslator.translator.addMap(name);
    }
}

