/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRange
extends AbstractNumericRange<Double> {
    protected double _min;
    protected double _max;

    public NumericRange() {
        this(0.0, 1.0);
    }

    public NumericRange(double d, double d2) {
        this._min = Math.min(d, d2);
        this._max = Math.max(d, d2);
    }

    public NumericRange(NumericRange numericRange) {
        this(numericRange.minimum(), numericRange.maximum());
    }

    @Override
    public Range<Double> copy() {
        return new NumericRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double d) {
        double d2 = this._min;
        if (d2 == d) {
            return;
        }
        assert (d <= this._max);
        this._min = d;
        this.firePropertyChange("min", d2, d);
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double d) {
        double d2 = this._max;
        if (d2 == d) {
            return;
        }
        assert (d >= this._min);
        this._max = d;
        this.firePropertyChange("max", d2, d);
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public void adjust(Double d, Double d2) {
        this.setMin(d);
        this.setMax(d2);
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    @Override
    public boolean contains(Double d) {
        return d != null && d >= this._min && d <= this._max;
    }

    public NumericRange stretch(double d) {
        return this.stretch(d, d);
    }

    public NumericRange stretch(double d, double d2) {
        double d3 = (this._max + this._min) / 2.0;
        double d4 = this.size() / 2.0;
        return new NumericRange(d3 - d4 * d, d3 + d4 * d2);
    }

    public boolean equals(Object object) {
        if (object instanceof NumericRange) {
            NumericRange numericRange = (NumericRange)object;
            return this._min == numericRange._min && this._max == numericRange._max;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this._max * 29.0 + this._min);
    }

    public String toString() {
        return String.format("#<NumericRange min=%f max=%f>", this._min, this._max);
    }

    public static NumericRange union(NumericRange numericRange, NumericRange numericRange2) {
        if (numericRange == null) {
            return numericRange2;
        }
        if (numericRange2 == null) {
            return numericRange;
        }
        double d = numericRange._min;
        double d2 = numericRange2._min;
        double d3 = numericRange._max;
        double d4 = numericRange2._max;
        double d5 = Math.min(d, d2);
        double d6 = Math.max(d3, d4);
        return new NumericRange(d5, d6);
    }
}

