/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;
import org.apache.tools.ant.taskdefs.optional.junit.XMLConstants;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLJUnitResultFormatter
implements JUnitResultFormatter,
XMLConstants {
    private Document doc;
    private Element rootElement;
    private Hashtable testElements = new Hashtable();
    private Hashtable failedTests = new Hashtable();
    private Hashtable testStarts = new Hashtable();
    private OutputStream out;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    public void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    public void startTestSuite(JUnitTest suite) {
        this.doc = XMLJUnitResultFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement("testsuite");
        this.rootElement.setAttribute("name", suite.getName());
        Element propsElement = this.doc.createElement("properties");
        this.rootElement.appendChild(propsElement);
        Properties props = suite.getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element propElement = this.doc.createElement("property");
                propElement.setAttribute("name", name);
                propElement.setAttribute("value", props.getProperty(name));
                propsElement.appendChild(propElement);
            }
        }
    }

    public void endTestSuite(JUnitTest suite) throws BuildException {
        this.rootElement.setAttribute("tests", "" + suite.runCount());
        this.rootElement.setAttribute("failures", "" + suite.failureCount());
        this.rootElement.setAttribute("errors", "" + suite.errorCount());
        this.rootElement.setAttribute("time", "" + (double)suite.getRunTime() / 1000.0);
        if (this.out != null) {
            BufferedWriter wri = null;
            try {
                wri = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
                wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                new DOMElementWriter().write(this.rootElement, wri, 0, "  ");
                ((Writer)wri).flush();
            }
            catch (IOException exc) {
                throw new BuildException("Unable to write log file", exc);
            }
            finally {
                if (this.out != System.out && this.out != System.err && wri != null) {
                    try {
                        ((Writer)wri).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void startTest(Test t) {
        this.testStarts.put(t, new Long(System.currentTimeMillis()));
    }

    public void endTest(Test test) {
        if (!this.testStarts.containsKey(test)) {
            this.startTest(test);
        }
        Element currentTest = null;
        if (!this.failedTests.containsKey(test)) {
            currentTest = this.doc.createElement("testcase");
            currentTest.setAttribute("name", JUnitVersionHelper.getTestCaseName(test));
            currentTest.setAttribute("classname", test.getClass().getName());
            this.rootElement.appendChild(currentTest);
            this.testElements.put(test, currentTest);
        } else {
            currentTest = (Element)this.testElements.get(test);
        }
        Long l = (Long)this.testStarts.get(test);
        currentTest.setAttribute("time", "" + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("failure", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("error", test, t);
    }

    private void formatError(String type, Test test, Throwable t) {
        if (test != null) {
            this.endTest(test);
            this.failedTests.put(test, test);
        }
        Element nested = this.doc.createElement(type);
        Element currentTest = null;
        currentTest = test != null ? (Element)this.testElements.get(test) : this.rootElement;
        currentTest.appendChild(nested);
        String message = t.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute("message", t.getMessage());
        }
        nested.setAttribute("type", t.getClass().getName());
        String strace = JUnitTestRunner.getFilteredTrace(t);
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    private void formatOutput(String type, String output) {
        Element nested = this.doc.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.doc.createCDATASection(output));
    }
}

