/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.text.ParseException;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;
import org.apache.tools.ant.taskdefs.optional.extension.Specification;

class LibraryDisplayer {
    LibraryDisplayer() {
    }

    void displayLibrary(File file) throws BuildException {
        Manifest manifest = ExtensionUtil.getManifest(file);
        this.displayLibrary(file, manifest);
    }

    void displayLibrary(File file, Manifest manifest) throws BuildException {
        Extension extension;
        int i;
        Extension[] available = Extension.getAvailable(manifest);
        Extension[] required = Extension.getRequired(manifest);
        Extension[] options = Extension.getOptions(manifest);
        Specification[] specifications = this.getSpecifications(manifest);
        if (0 == available.length && 0 == required.length && 0 == options.length && 0 == specifications.length) {
            return;
        }
        String message = "File: " + file;
        int size = message.length();
        this.printLine(size);
        System.out.println(message);
        this.printLine(size);
        if (0 != available.length) {
            System.out.println("Extensions Supported By Library:");
            i = 0;
            while (i < available.length) {
                extension = available[i];
                System.out.println(extension.toString());
                ++i;
            }
        }
        if (0 != required.length) {
            System.out.println("Extensions Required By Library:");
            i = 0;
            while (i < required.length) {
                extension = required[i];
                System.out.println(extension.toString());
                ++i;
            }
        }
        if (0 != options.length) {
            System.out.println("Extensions that will be used by Library if present:");
            i = 0;
            while (i < options.length) {
                extension = options[i];
                System.out.println(extension.toString());
                ++i;
            }
        }
        if (0 != specifications.length) {
            System.out.println("Specifications Supported By Library:");
            i = 0;
            while (i < specifications.length) {
                Specification specification = specifications[i];
                this.displaySpecification(specification);
                ++i;
            }
        }
    }

    private void printLine(int size) {
        int i = 0;
        while (i < size) {
            System.out.print("-");
            ++i;
        }
        System.out.println();
    }

    private Specification[] getSpecifications(Manifest manifest) throws BuildException {
        try {
            return Specification.getSpecifications(manifest);
        }
        catch (ParseException pe) {
            throw new BuildException(pe.getMessage(), pe);
        }
    }

    private void displaySpecification(Specification specification) {
        String[] sections = specification.getSections();
        if (null != sections) {
            StringBuffer sb = new StringBuffer("Sections: ");
            int i = 0;
            while (i < sections.length) {
                sb.append(" ");
                sb.append(sections[i]);
                ++i;
            }
            System.out.println(sb);
        }
        System.out.println(specification.toString());
    }
}

