/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;

public class CommonsLoggingListener
implements BuildListener,
BuildLogger {
    private boolean initialized = false;
    private LogFactory logFactory;
    PrintStream out = System.out;
    PrintStream err = System.err;

    private Log getLog(String cat, String suffix) {
        if (suffix != null) {
            suffix = suffix.replace('.', '-');
            suffix = suffix.replace(' ', '-');
            cat = cat + "." + suffix;
        }
        PrintStream tmpOut = System.out;
        PrintStream tmpErr = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        if (!this.initialized) {
            try {
                this.logFactory = LogFactory.getFactory();
            }
            catch (LogConfigurationException e) {
                e.printStackTrace(System.err);
                return null;
            }
        }
        this.initialized = true;
        Log log = this.logFactory.getInstance(cat);
        System.setOut(tmpOut);
        System.setErr(tmpErr);
        return log;
    }

    public void buildStarted(BuildEvent event) {
        String categoryString = "org.apache.tools.ant.Project";
        Log log = this.getLog(categoryString, null);
        if (this.initialized) {
            this.realLog(log, "Build started.", 2, null);
        }
    }

    public void buildFinished(BuildEvent event) {
        if (this.initialized) {
            String categoryString = "org.apache.tools.ant.Project";
            Log log = this.getLog(categoryString, event.getProject().getName());
            if (event.getException() == null) {
                this.realLog(log, "Build finished.", 2, null);
            } else {
                this.realLog(log, "Build finished with error.", 0, event.getException());
            }
        }
    }

    public void targetStarted(BuildEvent event) {
        if (this.initialized) {
            Log log = this.getLog("org.apache.tools.ant.Target", event.getTarget().getName());
            this.realLog(log, "Start: " + event.getTarget().getName(), 4, null);
        }
    }

    public void targetFinished(BuildEvent event) {
        if (this.initialized) {
            String targetName = event.getTarget().getName();
            Log log = this.getLog("org.apache.tools.ant.Target", event.getTarget().getName());
            if (event.getException() == null) {
                this.realLog(log, "Target end: " + targetName, 4, null);
            } else {
                this.realLog(log, "Target \"" + targetName + "\" finished with error.", 0, event.getException());
            }
        }
    }

    public void taskStarted(BuildEvent event) {
        if (this.initialized) {
            Log log;
            Task realObj;
            Task task;
            Task real = task = event.getTask();
            if (task instanceof UnknownElement && (realObj = ((UnknownElement)task).getTask()) != null) {
                real = realObj;
            }
            if ((log = this.getLog(real.getClass().getName(), null)).isTraceEnabled()) {
                this.realLog(log, "Task \"" + task.getTaskName() + "\" started ", 3, null);
            }
        }
    }

    public void taskFinished(BuildEvent event) {
        if (this.initialized) {
            Task realObj;
            Task task;
            Task real = task = event.getTask();
            if (task instanceof UnknownElement && (realObj = ((UnknownElement)task).getTask()) != null) {
                real = realObj;
            }
            Log log = this.getLog(real.getClass().getName(), null);
            if (event.getException() == null) {
                if (log.isTraceEnabled()) {
                    this.realLog(log, "Task \"" + task.getTaskName() + "\" finished.", 3, null);
                }
            } else {
                this.realLog(log, "Task \"" + task.getTaskName() + "\" finished with error.", 0, event.getException());
            }
        }
    }

    public void messageLogged(BuildEvent event) {
        if (this.initialized) {
            Object categoryObject = event.getTask();
            String categoryString = null;
            String categoryDetail = null;
            if (categoryObject == null) {
                categoryObject = event.getTarget();
                if (categoryObject == null) {
                    categoryObject = event.getProject();
                    categoryString = "org.apache.tools.ant.Project";
                    categoryDetail = event.getProject().getName();
                } else {
                    categoryString = "org.apache.tools.ant.Target";
                    categoryDetail = event.getTarget().getName();
                }
            } else if (event.getTarget() != null) {
                categoryString = categoryObject.getClass().getName();
                categoryDetail = event.getTarget().getName();
            } else {
                categoryString = categoryObject.getClass().getName();
            }
            Log log = this.getLog(categoryString, categoryDetail);
            int priority = event.getPriority();
            String message = event.getMessage();
            this.realLog(log, message, priority, null);
        }
    }

    private void realLog(Log log, String message, int priority, Throwable t) {
        PrintStream tmpOut = System.out;
        PrintStream tmpErr = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        switch (priority) {
            case 0: {
                if (t == null) {
                    log.error((Object)message);
                    break;
                }
                log.error((Object)message, t);
                break;
            }
            case 1: {
                if (t == null) {
                    log.warn((Object)message);
                    break;
                }
                log.warn((Object)message, t);
                break;
            }
            case 2: {
                if (t == null) {
                    log.info((Object)message);
                    break;
                }
                log.info((Object)message, t);
                break;
            }
            case 3: {
                log.debug((Object)message);
                break;
            }
            case 4: {
                log.debug((Object)message);
                break;
            }
            default: {
                log.error((Object)message);
            }
        }
        System.setOut(tmpOut);
        System.setErr(tmpErr);
    }

    public void setMessageOutputLevel(int level) {
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = output;
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = err;
    }
}

