/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.test.AbstractResultCompare;
import ch.e2e.test.E2EAssert;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.TestResult;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServiceTestResultCompare
extends AbstractResultCompare {
    public static final String KEY_OPTION_TEST_FILE = "service.test.compare.test.file";

    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException, XPathExpressionException {
        File testFile = (File)this.getOptionValue(KEY_OPTION_TEST_FILE, test.getRunProperties());
        E2ETest.assertTrue((String)("File " + testFile.getAbsolutePath() + " does not exists."), (boolean)testFile.exists());
        Document testDocument = this.getDocument(testFile);
        NodeList errorNodeList = (NodeList)DomUtilities.evaluate((Node)testDocument, (String)"/Errorlist/*", (QName)XPathConstants.NODESET);
        if (errorNodeList.getLength() > 0) {
            ArrayList<ErrorDetail> errorList = new ArrayList<ErrorDetail>();
            for (int i = 0; i < errorNodeList.getLength(); ++i) {
                Node childNode = errorNodeList.item(i);
                String code = childNode.getAttributes().getNamedItem("code").getTextContent();
                errorList.add(new ErrorDetail((Object)code));
            }
            E2EAssert.fail((String)"Deployment unsuccessful", errorList);
        }
    }

    public TestResult getTestResult(boolean includeHiddenData, Map<String, String> properties) {
        Document testDocument = this.getTestDocument(properties);
        StringWriter testData = new StringWriter();
        if (testDocument != null) {
            try {
                DomUtilities.serialize((Writer)testData, (Document)testDocument, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TestResult("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Errorlist/>", testData.toString());
    }

    protected void createOptions() {
        this.addOption(KEY_OPTION_TEST_FILE, (Option)new FileOption("Test file", 0));
    }

    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        Element result = this.toXml(ownerDocument, "options");
        if (includeType) {
            result.setAttribute("type", this.getType().getName());
        }
        return result;
    }

    public void toXml(Element parent) {
        Element result = this.toXml(parent.getOwnerDocument(), "ServiceTestResultCompare");
        parent.appendChild(result);
    }

    private Element toXml(Document parent, String name) {
        Element result = parent.createElement(name);
        if (this.getName() != null && this.getName().length() > 0) {
            result.setAttribute("name", this.getName());
        }
        ((Option)this.getOptions().get(KEY_OPTION_TEST_FILE)).toXml(result);
        return result;
    }

    protected Document getTestDocument(Map<String, String> properties) {
        File testFile = (File)this.getOptionValue(KEY_OPTION_TEST_FILE, properties);
        return this.getDocument(testFile);
    }

    private Document getDocument(File testFile) {
        Document document = null;
        try {
            if (testFile != null) {
                document = DomUtilities.parse((File)testFile, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }
}

