/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.dom.DomUtilities;
import ch.e2e.dom.XPathFactory;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class VariableStore {
    private File variableStore;

    public VariableStore(File variableStore) {
        this.variableStore = variableStore;
    }

    public String expandVariables(String request) {
        if (this.variableStore != null && this.variableStore.exists()) {
            Properties variables = new Properties(this.variableStore);
            request = StringTools.replaceProperties((String)request, (Map)variables);
        }
        return request;
    }

    public void extractVariableValue(String xPathString, String variableName, InputStream result) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        if (xPathString != null && !xPathString.isEmpty() && variableName != null && !variableName.isEmpty() && this.variableStore != null && (this.variableStore.canWrite() || this.variableStore.getParentFile().canWrite())) {
            Document inputSource = DomUtilities.parse((InputStream)result, (boolean)false, (boolean)false);
            XPath xPath = XPathFactory.getInstance().newXPath();
            XPathExpression xPathExpression = xPath.compile(xPathString);
            String variable = xPathExpression.evaluate(inputSource);
            Properties variables = new Properties(this.variableStore);
            variables.setProperty(variableName, variable);
            variables.write();
        }
    }
}

