/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.compiler.build.test.RepositoryCompare;
import ch.e2e.builder.compiler.build.test.RepositoryDifference;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.ZipUtilities;
import ch.e2e.test.E2EComparisonController;
import ch.e2e.test.E2EDiff;
import ch.e2e.test.E2EDifferenceEngine;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.TestResult;
import ch.e2e.test.XMLDiffErrorDetail;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.w3c.dom.Document;

public class TabfileMergeCompare
extends RepositoryCompare {
    public static final String KEY = "TabfileMergeCompare";

    @Override
    public boolean hasIgnoredDifferences() {
        return true;
    }

    public TestResult getTestResult(ErrorDetail errorDetail, boolean includeHiddenData, Map<String, String> properties) {
        TestResult result;
        if (errorDetail instanceof XMLDiffErrorDetail) {
            if (errorDetail.getTestResult() == null) {
                String filename = ((XMLDiffErrorDetail)errorDetail).getFile();
                File referenceFile = (File)this.getOptionValue("xml.compare.reference.file", properties);
                File testFile = (File)this.getOptionValue("xml.compare.test.file", properties);
                Document testDocument = null;
                Document referenceDocument = null;
                try {
                    testDocument = ZipUtilities.getZippedDocumentFromFile((File)testFile, (String)filename.replace('\\', '/'));
                }
                catch (Exception e) {
                    try {
                        testDocument = ZipUtilities.getZippedDocumentFromFile((File)testFile, (String)filename);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    referenceDocument = ZipUtilities.getZippedDocumentFromFile((File)referenceFile, (String)filename);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result = this.getTestResult(testDocument, referenceDocument, includeHiddenData, properties);
            } else {
                result = errorDetail.getTestResult();
            }
        } else {
            result = super.getTestResult(errorDetail, includeHiddenData, properties);
        }
        return result;
    }

    @Override
    protected void testFileContent(ZipFile referenceFile, ZipEntry referenceEntry, ZipFile testFile, ZipEntry testEntry, RepositoryDifference diff) {
        Document referenceDocument = this.createDocumentFromEntry(referenceFile, referenceEntry, "reference");
        Document testDocument = this.createDocumentFromEntry(testFile, testEntry, "test");
        this.compareDocuments(testDocument, referenceDocument, referenceEntry.getName(), diff);
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        String defaultName = "Compare tabfiles";
        this.getNameOption().setDependencyString(defaultName);
        this.getNameOption().setDefaultValue((Object)defaultName);
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    private void compareDocuments(Document testDocument, Document referenceDocument, String referenceName, RepositoryDifference diff) {
        if (referenceDocument != null && testDocument != null) {
            E2EComparisonController controller = new E2EComparisonController();
            E2EDiff xmlDiff = new E2EDiff(referenceDocument, testDocument, (DifferenceEngine)new E2EDifferenceEngine((ComparisonController)controller, this.getIgnoredAttributes(), this.getIgnoredElements()), referenceName);
            diff.appendXMLDiff(xmlDiff);
        }
    }

    private Document createDocumentFromEntry(ZipFile test, ZipEntry zipEntry, String source) {
        Document document = null;
        try {
            document = DomUtilities.parse((InputStream)test.getInputStream(zipEntry), (boolean)false, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            E2ETest.fail((String)("Could not read " + source + " entry '" + zipEntry.getName() + "' from '" + test.getName() + "'"));
        }
        return document;
    }
}

