/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.XMLCompare;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TabfileCompare
extends XMLCompare {
    private String umlFilename;

    public void init(Element options) {
        super.init(options);
        NodeList umlDocuments = options.getElementsByTagName("umldocument");
        if (umlDocuments != null && umlDocuments.getLength() == 1) {
            this.umlFilename = ((Element)umlDocuments.item(0)).getAttribute("name");
        }
    }

    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException, XPathExpressionException {
        File srcFolder = CompilerConstants.getSourceFolder();
        File umlFile = new File(srcFolder, this.umlFilename);
        File projectFolder = new File(E2EBuilderProject.locateProjectHome((File)umlFile));
        UmlDocumentCompilerSettings compilerSettings = new UmlDocumentCompilerSettings(projectFolder);
        compilerSettings.setUmlSourceFolder(srcFolder);
        UmlDocument umlDocument = new UmlDocumentFactory(compilerSettings).getUmlDocument(umlFile);
        File tabfiles = new File(umlDocument.getDocumentWorkingFolder(), umlDocument.getUniqueId() + ".tabfiles");
        this.setTestFile(new CompareFile(tabfiles));
        super.doTest(test);
    }
}

