/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.test.E2EDiff;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.XMLDiffErrorDetail;
import java.io.File;
import java.util.ArrayList;

public class RepositoryDifference {
    private File referenceFile;
    private File testFile;
    private ArrayList<ErrorDetail<String>> messages = new ArrayList();
    private ArrayList<XMLDiffErrorDetail> xmlDiffs = new ArrayList();
    private boolean identical = true;

    public RepositoryDifference(File referenceFile, File testFile) {
        this.referenceFile = referenceFile;
        if (!referenceFile.exists()) {
            this.messages.add((ErrorDetail<String>)new ErrorDetail((Object)("The reference repository '" + referenceFile.getAbsolutePath() + "' does not exists.")));
            this.identical = false;
        }
        this.testFile = testFile;
        if (!testFile.exists()) {
            this.messages.add((ErrorDetail<String>)new ErrorDetail((Object)("The test repository '" + testFile.getAbsolutePath() + "' does not exists.")));
            this.identical = false;
        }
    }

    public void addMissingEntry(String name) {
        this.messages.add((ErrorDetail<String>)new ErrorDetail((Object)("Missing entry '" + name + "' in test repository.")));
        this.identical = false;
    }

    public void addAdditionalEntry(String name) {
        this.messages.add((ErrorDetail<String>)new ErrorDetail((Object)("Additional entry '" + name + "' in test repository found.")));
        this.identical = false;
    }

    public void addDirectoryMissmatch(String name, boolean directoryInReference) {
        this.messages.add((ErrorDetail<String>)new ErrorDetail((Object)("'" + name + "' is directory in '" + (directoryInReference ? this.referenceFile.getAbsolutePath() : this.testFile.getAbsolutePath()) + "' and file in '" + (directoryInReference ? this.testFile.getAbsolutePath() : this.referenceFile.getAbsolutePath()) + "'.")));
        this.identical = false;
    }

    public void appendXMLDiff(E2EDiff xmlDiff) {
        if (!xmlDiff.identical()) {
            StringBuffer diffMessages = new StringBuffer();
            xmlDiff.appendMessage(diffMessages);
            this.xmlDiffs.add(new XMLDiffErrorDetail(xmlDiff.getReference(), xmlDiff.getMessages()));
            this.identical = false;
        }
    }

    public boolean isIdentical() {
        return this.identical;
    }

    public ArrayList<ErrorDetail<String>> getMessages() {
        return this.messages;
    }

    public ArrayList<XMLDiffErrorDetail> getXmlDiffs() {
        return this.xmlDiffs;
    }

    public String toString() {
        return this.messages.toString();
    }
}

