/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.compiler.build.test.RepositoryDifference;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2EAssert;
import ch.e2e.test.E2ETest;
import ch.e2e.test.TestResult;
import ch.e2e.test.Utilities;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.BooleanOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RepositoryCompare
extends XMLCompare {
    public static final String KEY = "RepositoryCompare";

    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException {
        File testRepository = (File)this.getOptionValue("xml.compare.test.file", test.getRunProperties());
        File referenceRepository = (File)this.getOptionValue("xml.compare.reference.file", test.getRunProperties());
        E2ETest.assertFalse((String)"Could not find the testRepository definition.", (testRepository == null ? 1 : 0) != 0);
        E2ETest.assertFalse((String)"Could not find the referenceRepository definition.", (referenceRepository == null ? 1 : 0) != 0);
        this.doCompare(testRepository, referenceRepository, test.getRunProperties());
    }

    public void init(Element options) {
        super.init(options);
    }

    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
    }

    public void toXml(Element parent) {
        Element result = this.toXml(parent.getOwnerDocument(), this.getKey());
        parent.appendChild(result);
    }

    protected String getKey() {
        return KEY;
    }

    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        Element result = this.toXml(ownerDocument, "options");
        if (includeType) {
            result.setAttribute("type", this.getType().getName());
        }
        return result;
    }

    public TestResult getTestResult(boolean includeHiddenData, Map<String, String> properties) {
        StringBuilder testData = new StringBuilder();
        StringBuilder referenceData = new StringBuilder();
        File referenceFile = (File)this.getOptionValue("xml.compare.reference.file", properties);
        this.fillRepositoryData(referenceFile, referenceData);
        File testFile = (File)this.getOptionValue("xml.compare.test.file", properties);
        this.fillRepositoryData(testFile, testData);
        return new TestResult(referenceData.toString(), testData.toString());
    }

    public void test2Reference(Map<String, String> properties) throws IOException {
        try {
            FileUtilities.copyFile((File)((File)this.getOptionValue("xml.compare.test.file", properties)), (File)((File)this.getOptionValue("xml.compare.reference.file", properties)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasIgnoredDifferences() {
        return false;
    }

    public void moveReferenceData(File oldReferenceFolder, File newReferenceFolder, Map<String, String> runProperties) {
        File referenceFile = (File)this.getOptionValue("xml.compare.reference.file", runProperties);
        if (referenceFile != null) {
            String path = FileUtilities.getRelativePath((File)referenceFile, (File)oldReferenceFolder);
            File newReferenceFile = new File(newReferenceFolder, path);
            if (newReferenceFile.exists()) {
                newReferenceFile.delete();
            } else {
                newReferenceFile.getParentFile().mkdirs();
            }
            if (referenceFile.renameTo(newReferenceFile)) {
                this.getOption("xml.compare.reference.file").setValue((Object)newReferenceFile);
            } else {
                System.out.println("Could not move " + referenceFile + " to " + newReferenceFile);
            }
            Utilities.deleteEmptyParents((File)referenceFile);
        }
    }

    public void removeReferenceData(Map<String, String> properties) {
        File referenceFile = (File)this.getOptionValue("xml.compare.reference.file", properties);
        if (referenceFile != null && referenceFile.delete()) {
            Utilities.deleteEmptyParents((File)referenceFile);
        }
    }

    protected void createOptions() {
        super.createOptions();
        int index = this.getOptionIndex("xml.compare.test.file");
        FileOption testFile = new FileOption("Test Repository", "xml.compare.test.file", index == -1 ? 1 : index);
        testFile.setDirectory(false);
        testFile.addFileExtension("rep", "E2E Bridge Repository");
        this.addOption("xml.compare.test.file", (Option)testFile);
        index = this.getOptionIndex("xml.compare.reference.file");
        FileOption referenceFile = new FileOption("Reference Repository", "xml.compare.reference.file", index == -1 ? 2 : index);
        referenceFile.setDirectory(false);
        referenceFile.addFileExtension("rep", "E2E Bridge Repository");
        this.addOption("xml.compare.reference.file", (Option)referenceFile);
        BooleanOption compare = (BooleanOption)this.getOption("xml.compare.type");
        compare.setTrueName("Compare equal");
        compare.setFalseName("Compare not equal");
        String defaultName = "Compare ${xml.compare.test.file.name}";
        this.getNameOption().addDependency("xml.compare.test.file");
        this.getNameOption().setDependencyString(defaultName);
        this.getNameOption().setDefaultValue((Object)defaultName);
    }

    protected void doCompare(File testFile, File referenceFile, Map<String, String> runProperties) throws IOException {
        RepositoryDifference diff = new RepositoryDifference(referenceFile, testFile);
        if (testFile.exists() && referenceFile.exists()) {
            this.compareFiles(testFile, referenceFile, diff);
        }
        boolean equal = (Boolean)this.getOptionValue("xml.compare.type", runProperties);
        ArrayList<Object> errorDetails = new ArrayList<Object>();
        errorDetails.addAll(diff.getMessages());
        errorDetails.addAll(diff.getXmlDiffs());
        E2EAssert.assertFalse((String)(referenceFile.getName() + " repositories are not identical"), errorDetails, (boolean)(equal ^ diff.isIdentical()));
    }

    protected void testFileContent(ZipFile referenceFile, ZipEntry referenceEntry, ZipFile testFile, ZipEntry testEntry, RepositoryDifference diff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillRepositoryData(File file, StringBuilder data) {
        if (file != null && file.exists()) {
            ZipFile repository = null;
            try {
                repository = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = repository.entries();
                TreeSet<String> entriesSet = new TreeSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName().replace('\\', '/');
                    if (name.startsWith("htdocs/svg")) continue;
                    entriesSet.add(name);
                }
                for (String name : entriesSet) {
                    data.append(name).append('\n');
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private Element toXml(Document parent, String name) {
        BooleanOption compareType;
        Boolean value;
        Element result = parent.createElement(name);
        if (this.getName() != null && this.getName().length() > 0) {
            result.setAttribute("name", this.getName());
        }
        Boolean bl = value = (compareType = (BooleanOption)this.getOptions().get("xml.compare.type")).getValue() == null ? (Boolean)compareType.getDefaultValue() : (Boolean)compareType.getValue();
        if (value.booleanValue()) {
            result.setAttribute("compareType", "equal");
        } else {
            result.setAttribute("compareType", "notequal");
        }
        ((Option)this.getOptions().get("xml.compare.reference.file")).toXml(result);
        ((Option)this.getOptions().get("xml.compare.test.file")).toXml(result);
        this.advancedOptionsToXml(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareFiles(File testFile, File referenceFile, RepositoryDifference diff) throws IOException {
        ZipFile reference = null;
        ZipFile test = null;
        try {
            test = new ZipFile(testFile);
            reference = new ZipFile(referenceFile);
            Enumeration<? extends ZipEntry> referenceEntries = reference.entries();
            ArrayList<String> entryNames = new ArrayList<String>();
            while (referenceEntries.hasMoreElements()) {
                String referenceName;
                ZipEntry referenceEntry = referenceEntries.nextElement();
                if (referenceEntry.isDirectory() || (referenceName = referenceEntry.getName().replace('\\', '/')).startsWith("htdocs/svg")) continue;
                entryNames.add(referenceName);
                ZipEntry testEntry = test.getEntry(referenceEntry.getName());
                if (testEntry == null) {
                    testEntry = test.getEntry(referenceName);
                }
                if (testEntry == null) {
                    testEntry = test.getEntry(referenceEntry.getName().replace('/', '\\'));
                }
                if (testEntry == null) {
                    diff.addMissingEntry(referenceEntry.getName());
                    continue;
                }
                if (!testEntry.getName().endsWith(".tab") && !testEntry.getName().endsWith(".xml")) continue;
                this.compareEntries(reference, referenceEntry, test, testEntry, diff);
            }
            this.findAdditionalEntries(test, entryNames, diff);
        }
        finally {
            if (test != null) {
                test.close();
            }
            if (reference != null) {
                reference.close();
            }
        }
    }

    private void findAdditionalEntries(ZipFile test, ArrayList<String> entryNames, RepositoryDifference diff) {
        Enumeration<? extends ZipEntry> testEntries = test.entries();
        while (testEntries.hasMoreElements()) {
            ZipEntry testEntry = testEntries.nextElement();
            String name = testEntry.getName().replace('\\', '/');
            if (name.startsWith("htdocs/svg") || testEntry.isDirectory() || entryNames.contains(testEntry.getName())) continue;
            diff.addAdditionalEntry(testEntry.getName());
        }
    }

    private void compareEntries(ZipFile referenceFile, ZipEntry referenceEntry, ZipFile testFile, ZipEntry testEntry, RepositoryDifference diff) {
        if (referenceEntry.isDirectory() && !testEntry.isDirectory()) {
            diff.addDirectoryMissmatch(referenceEntry.getName(), true);
        } else if (!referenceEntry.isDirectory() && testEntry.isDirectory()) {
            diff.addDirectoryMissmatch(referenceEntry.getName(), false);
        } else if (!referenceEntry.isDirectory()) {
            this.testFileContent(referenceFile, referenceEntry, testFile, testEntry, diff);
        }
    }
}

