/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.process.CompileProcess;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETask;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class CleanAllTask
extends E2ETask {
    public static final String KEY_OPTION_PROJECT_FOLDER = "clean.all.task.project.folder";

    public void doTest() throws Exception {
        String projectFolderString = null;
        File projectFolder = (File)this.getOptionValue(KEY_OPTION_PROJECT_FOLDER);
        if (projectFolder == null) {
            String projectHome = E2EBuilderProject.getProjectFolderName();
            if (projectHome != null) {
                projectFolder = new File(projectHome);
            }
        } else {
            projectFolderString = E2EBuilderProject.getProjectFolderName();
            E2EBuilderProject.setProjectFolderName((String)projectFolder.getAbsolutePath());
        }
        if (projectFolder != null) {
            File xmiIds;
            UmlDocumentCompilerSettings compilerSettings = new UmlDocumentCompilerSettings(projectFolder);
            UmlDocumentFactory umlDocumentFactory = new UmlDocumentFactory(compilerSettings);
            new E2EBuilderProject(projectFolder);
            this.deleteRepositories(compilerSettings);
            this.cleanWorkingFolder(compilerSettings);
            if (this.getSource("idfile") != null && (xmiIds = (File)this.getSource("idfile").getValue()) != null) {
                CleanAllTask.assertTrue((String)("XMI ID file '" + xmiIds.getAbsolutePath() + "' does not exists"), (boolean)xmiIds.exists());
                File workFolder = new File(E2EBuilderProject.getProjectFolderName(), CompilerConstants.WORK_FOLDER);
                FileUtilities.copyFile((File)xmiIds, (File)new File(workFolder, ".xmi.id"));
            }
            this.reloadDocuments(compilerSettings);
            if (projectFolderString != null) {
                E2EBuilderProject.setProjectFolderName((String)projectFolderString);
                new E2EBuilderProject(new File(projectFolderString));
            }
        }
    }

    protected void createOptions() {
        FileOption projectFolder = new FileOption("Project Folder", KEY_OPTION_PROJECT_FOLDER, 4);
        projectFolder.setRequired(false);
        projectFolder.setDirectory(true);
        this.addOption(KEY_OPTION_PROJECT_FOLDER, (Option)projectFolder);
    }

    public String getRecommendedCompareType() {
        return null;
    }

    private void deleteRepositories(UmlDocumentCompilerSettings compilerSettings) {
        File repositoriesFolder = compilerSettings.getRepositoryFolder();
        FileUtilities.delete((File)repositoriesFolder, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return name.endsWith(".rep") || name.endsWith(".lrep");
            }
        }, (boolean)true);
    }

    private void cleanWorkingFolder(UmlDocumentCompilerSettings compilerSettings) throws IOException {
        File workFolder = compilerSettings.getWorkFolder();
        FileUtilities.deleteAll((File)workFolder);
    }

    private void reloadDocuments(UmlDocumentCompilerSettings umlDocumentCompilerSettings) {
        File[] documentFiles;
        UmlDocumentFactory factory = new UmlDocumentFactory(umlDocumentCompilerSettings);
        for (File documentFile : documentFiles = FileUtilities.getFileList((File)umlDocumentCompilerSettings.getUmlSourceFolder(), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.getName().endsWith(".xml.zip") || path.getName().endsWith(".xml");
            }
        }, (boolean)true)) {
            UmlDocument umlDocument = factory.getUmlDocument(documentFile);
            new CompileProcess(umlDocument).run("Xmi2Descriptor_Task");
        }
    }
}

