/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.rest;

import ch.e2e.builder.trace.testcase.LogFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.message.MessageUtils;

@ConstrainedTo(value=RuntimeType.CLIENT)
@PreMatching
@Priority(value=0x7FFFFFFF)
class LoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private static final String ENTITY_STREAM_PROPERTY = "LoggingFilter.entityStream";
    private final File requestLog;
    private final File responseLog;

    LoggingFilter(LogFile requestLog, LogFile responseLog) {
        this(requestLog.getLogFile(), responseLog.getLogFile());
    }

    LoggingFilter(File requestLog, File responseLog) {
        this.requestLog = requestLog;
        this.responseLog = responseLog;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        ByteArrayOutputStream logStream = new ByteArrayOutputStream();
        Charset charset = MessageUtils.getCharset((MediaType)requestContext.getMediaType());
        LoggingFilter.writeRequestLine(logStream, requestContext, charset);
        LoggingFilter.writeHeaders(logStream, (MultivaluedMap<String, String>)requestContext.getStringHeaders(), charset);
        if (requestContext.hasEntity()) {
            LoggingFilter.writeRequestBody(requestContext, logStream, charset);
        } else {
            this.logRequest(logStream);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        context.proceed();
        LoggingStream logStream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        if (logStream != null) {
            this.logRequest(logStream.getLogStream());
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (this.responseLog.exists()) {
            this.responseLog.delete();
        }
        if (!this.responseLog.getParentFile().exists()) {
            this.responseLog.getParentFile().mkdirs();
        }
        this.logResponse(responseContext);
    }

    private void logResponse(ClientResponseContext responseContext) throws IOException {
        try (FileOutputStream logStream = new FileOutputStream(this.responseLog);){
            Charset charset = MessageUtils.getCharset((MediaType)responseContext.getMediaType());
            this.writeResponseLine(logStream, responseContext, charset);
            LoggingFilter.writeHeaders(logStream, (MultivaluedMap<String, String>)responseContext.getHeaders(), charset);
            if (responseContext.hasEntity()) {
                this.writeResponseBody(responseContext, logStream, charset);
            }
        }
    }

    private static void writeRequestLine(OutputStream logStream, ClientRequestContext requestContext, Charset charset) throws IOException {
        logStream.write(String.format("%s %s\n\n", requestContext.getMethod(), requestContext.getUri().toASCIIString()).getBytes(charset));
    }

    private static void writeRequestBody(ClientRequestContext requestContext, ByteArrayOutputStream logStream, Charset charset) throws IOException {
        LoggingFilter.writeNewline(logStream, charset);
        requestContext.setEntityStream((OutputStream)new LoggingStream(logStream, requestContext.getEntityStream()));
        requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)requestContext.getEntityStream());
    }

    private void writeResponseLine(FileOutputStream logStream, ClientResponseContext responseContext, Charset charset) throws IOException {
        Response.StatusType status = responseContext.getStatusInfo();
        logStream.write(String.format("%d - %s\n\n", status.getStatusCode(), status.getReasonPhrase()).getBytes(charset));
    }

    private void writeResponseBody(ClientResponseContext responseContext, FileOutputStream logStream, Charset charset) throws IOException {
        LoggingFilter.writeNewline(logStream, charset);
        responseContext.setEntityStream(this.logInboundEntity(logStream, responseContext.getEntityStream(), LoggingFilter.getContentLength(responseContext)));
    }

    private static void writeNewline(OutputStream logStream, Charset charset) throws IOException {
        logStream.write("\n".getBytes(charset));
    }

    private static void writeHeaders(OutputStream logStream, MultivaluedMap<String, String> headers, Charset charset) {
        headers.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            try {
                logStream.write(String.format("%s: %s\n", entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue())).getBytes(charset));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    InputStream logInboundEntity(OutputStream logStream, InputStream in, int contentLength) throws IOException {
        int length;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(contentLength);
        byte[] bytes = new byte[4096];
        while ((length = in.read(bytes)) != -1) {
            logStream.write(bytes, 0, length);
        }
        in.reset();
        return in;
    }

    private static int getContentLength(ClientResponseContext responseContext) {
        try {
            return Integer.parseInt(responseContext.getHeaderString("Content-Length")) + 1;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    void logRequest(ByteArrayOutputStream logStream) throws IOException {
        if (this.requestLog.exists()) {
            this.requestLog.delete();
        }
        if (!this.requestLog.getParentFile().exists()) {
            this.requestLog.getParentFile().mkdirs();
        }
        try (OutputStream out = Files.newOutputStream(this.requestLog.toPath(), new OpenOption[0]);){
            logStream.writeTo(out);
        }
    }

    private static class LoggingStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream logStream;

        LoggingStream(ByteArrayOutputStream logStream, OutputStream inner) {
            super(inner);
            this.logStream = logStream;
        }

        ByteArrayOutputStream getLogStream() {
            return this.logStream;
        }

        @Override
        public void write(int i) throws IOException {
            this.logStream.write(i);
            super.write(i);
        }
    }
}

