/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.option.axiom.AxiomAttributeWrapper;
import net.sf.saxon.option.axiom.AxiomDocument;
import net.sf.saxon.option.axiom.AxiomElementNodeWrapper;
import net.sf.saxon.option.axiom.AxiomWriter;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class AxiomObjectModel
extends TreeModel
implements ExternalObjectModel {
    private static AxiomObjectModel THE_INSTANCE = new AxiomObjectModel();

    public static AxiomObjectModel getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getDocumentClassName() {
        return "org.apache.axiom.om.OMDocument";
    }

    @Override
    public String getIdentifyingURI() {
        return "http://ws.apache.org/jaxp/xpath/axiom";
    }

    @Override
    public Builder makeBuilder(PipelineConfiguration pipe) {
        return new AxiomWriter(pipe);
    }

    @Override
    public int getSymbolicValue() {
        return 5;
    }

    @Override
    public String getName() {
        return "Axiom";
    }

    private static boolean isRecognizedNode(Object object) {
        return object instanceof OMDocument || object instanceof OMElement || object instanceof OMAttribute || object instanceof OMText || object instanceof OMComment || object instanceof OMProcessingInstruction || object instanceof OMNamespace;
    }

    @Override
    public PJConverter getPJConverter(Class<?> targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(Sequence<?> value, Class<?> targetClass, XPathContext context) {
                    return AxiomObjectModel.this.convertXPathValueToObject(value, targetClass);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class sourceClass, Configuration config) {
        if (this.isRecognizedNodeClass(sourceClass)) {
            return new JPConverter(){

                @Override
                public Sequence<?> convert(Object object, XPathContext context) throws XPathException {
                    return AxiomObjectModel.this.convertObjectToXPathValue(object, context.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    private boolean isRecognizedNodeClass(Class nodeClass) {
        return OMDocument.class.isAssignableFrom(nodeClass) || OMElement.class.isAssignableFrom(nodeClass) || OMAttribute.class.isAssignableFrom(nodeClass) || OMText.class.isAssignableFrom(nodeClass) || OMComment.class.isAssignableFrom(nodeClass) || OMProcessingInstruction.class.isAssignableFrom(nodeClass) || OMNamespace.class.isAssignableFrom(nodeClass);
    }

    @Override
    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    @Override
    public boolean sendSource(Source source, Receiver receiver) {
        return false;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    private Sequence<?> convertObjectToXPathValue(Object object, Configuration config) {
        if (AxiomObjectModel.isRecognizedNode(object)) {
            if (object instanceof OMDocument) {
                return new AxiomDocument((OMDocument)object, "", config).getRootNode();
            }
            if (object instanceof OMNode) {
                AxiomDocument docWrapper = new AxiomDocument(AxiomObjectModel.getOMDocument((OMNode)object), "", config);
                return this.wrapNode(docWrapper, object);
            }
            if (object instanceof OMAttribute) {
                AxiomDocument docWrapper = new AxiomDocument(AxiomObjectModel.getOMDocument((OMNode)((OMAttribute)object).getOwner()), "", config);
                return this.wrapNode(docWrapper, object);
            }
            return null;
        }
        return null;
    }

    private static OMDocument getOMDocument(OMNode node) {
        OMContainer parent = node instanceof OMContainer ? (OMContainer)node : node.getParent();
        while (!(parent instanceof OMDocument) && parent != null) {
            parent = node.getParent();
        }
        return (OMDocument)parent;
    }

    private Object convertXPathValueToObject(Sequence<?> value, Class<?> target) {
        Object u;
        if (value instanceof VirtualNode && target.isAssignableFrom((u = ((VirtualNode)value).getRealNode()).getClass())) {
            return u;
        }
        return null;
    }

    public NodeInfo wrapNode(AxiomDocument document, Object node) {
        if (node instanceof OMDocument) {
            return document.getRootNode();
        }
        if (node instanceof OMNode) {
            return AxiomDocument.makeWrapper((OMNode)node, document, null, -1);
        }
        if (node instanceof OMAttribute) {
            AxiomElementNodeWrapper elem = (AxiomElementNodeWrapper)this.wrapNode(document, ((OMAttribute)node).getOwner());
            return new AxiomAttributeWrapper((OMAttribute)node, elem, -1);
        }
        throw new IllegalArgumentException();
    }
}

