/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.trans;

import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.expr.JavaExtensionFunctionCall;
import com.saxonica.expr.MemoFunction;
import com.saxonica.functions.hof.AtomicConstructorFunction;
import com.saxonica.functions.hof.CoercedFunction;
import com.saxonica.functions.hof.CurriedFunction;
import com.saxonica.functions.hof.FunctionLiteral;
import com.saxonica.functions.hof.FunctionSequenceCoercer;
import com.saxonica.functions.hof.PartialApply;
import com.saxonica.functions.hof.UserFunctionReference;
import com.saxonica.trans.EvaluateInstr;
import com.saxonica.xsltextn.instruct.Assign;
import com.saxonica.xsltextn.instruct.DoInstr;
import com.saxonica.xsltextn.instruct.While;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.OriginalFunction;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.MathFunctionSet;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.PackageLoaderHE;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public class PackageLoaderPE
extends PackageLoaderHE {
    public PackageLoaderPE(ProfessionalConfiguration config) {
        super(config);
    }

    @Override
    protected void readSchemaNamespaces(NodeInfo packageElement) throws XPathException {
        NodeInfo varElement;
        AxisIterator iterator = packageElement.iterateAxis((byte)3, new NameTest(1, "http://ns.saxonica.com/xslt/export", "schema", this.getConfiguration().getNamePool()));
        Configuration config = this.getConfiguration();
        while ((varElement = iterator.next()) != null) {
            String ns = varElement.getAttributeValue("", "ns");
            if (!config.isSchemaAvailable(ns) && !ns.equals("http://ns.saxonica.com/anonymous-type")) {
                throw new XPathException("The XSLT package requires access to " + (ns.isEmpty() ? "a no-namespace schema" : "a schema for namespace " + ns) + ", but this is not available in this Configuration", "SXPK0003");
            }
            ((StylesheetPackage)this.packStack.peek()).getSchemaNamespaces().add(ns);
        }
    }

    @Override
    protected UserFunction makeFunction(String flags) {
        return flags.contains("m") ? new MemoFunction() : new UserFunction();
    }

    @Override
    protected boolean processComponentReference(StylesheetPackage pack, ComponentInvocation call) throws XPathException {
        Component c;
        SymbolicName sn = call.getSymbolicName();
        if (call instanceof UserFunctionReference) {
            c = pack.getComponent(sn);
            if (c == null) {
                return super.processComponentReference(pack, call);
            }
        } else {
            return super.processComponentReference(pack, call);
        }
        ((UserFunctionReference)call).setFunction((UserFunction)c.getActor());
        return false;
    }

    static {
        eMap.put("acFnRef", (loader, element) -> {
            StructuredQName name = loader.getQNameAttribute(element, "name");
            SchemaType type = loader.getConfiguration().getSchemaType(name);
            if (!(type instanceof AtomicType)) {
                throw new XPathException("No atomic type " + name.getEQName() + " found");
            }
            AtomicConstructorFunction fn = new AtomicConstructorFunction((AtomicType)type, null);
            return new FunctionLiteral(fn);
        });
        eMap.put("assign", (loader, element) -> {
            loader.needsPELicense("saxon:assign");
            StructuredQName varName = loader.getQNameAttribute(element, "name");
            Expression select = loader.getFirstChildExpression(element);
            Assign inst = new Assign(select);
            loader.completionActions.add(() -> {
                SymbolicName sn = new SymbolicName(206, varName);
                GlobalVariable var = (GlobalVariable)loader.getPackage().getComponent(sn).getActor();
                inst.fixup(var);
            });
            return inst;
        });
        eMap.put("coercedFn", (loader, element) -> {
            CoercedFunction coercedFn;
            ItemType type = loader.parseItemTypeAttribute(element, "type");
            Expression target = loader.getFirstChildExpression(element);
            if (target instanceof UserFunctionReference) {
                CoercedFunction coercedFn2 = coercedFn = new CoercedFunction((SpecificFunctionType)type);
                SymbolicName name = ((UserFunctionReference)target).getSymbolicName();
                loader.completionActions.add(() -> coercedFn2.setTargetFunction(loader.userFunctions.get(name)));
            } else if (target instanceof FunctionLiteral) {
                Function targetFn = (Function)((Literal)target).getValue();
                coercedFn = new CoercedFunction(targetFn, (SpecificFunctionType)type);
            } else {
                throw new AssertionError();
            }
            return Literal.makeLiteral(coercedFn);
        });
        eMap.put("curriedFunc", (loader, element) -> {
            NodeInfo child;
            Expression target = loader.getFirstChildExpression(element);
            Function targetFn = (Function)((Literal)target).getValue();
            NodeInfo args = loader.getChild(element, 1);
            int count = 0;
            AxisIterator iter = args.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((child = iter.next()) != null) {
                ++count;
            }
            Sequence[] argValues = new Sequence[count];
            iter = args.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            count = 0;
            while ((child = iter.next()) != null) {
                if (child.getLocalPart().equals("x")) {
                    argValues[count++] = null;
                    continue;
                }
                Expression arg = loader.loadExpression(child);
                argValues[count++] = ((Literal)arg).getValue();
            }
            CurriedFunction f = new CurriedFunction(targetFn, argValues);
            return Literal.makeLiteral(f);
        });
        eMap.put("do", (loader, element) -> {
            Expression arg = loader.getFirstChildExpression(element);
            return new DoInstr(arg);
        });
        eMap.put("evaluate", (loader, element) -> {
            NodeInfo wp;
            String namespaces;
            SequenceType required = loader.parseSequenceType(element, "as");
            Expression xpath = loader.getExpressionWithRole(element, "xpath");
            Expression contextItem = loader.getExpressionWithRole(element, "cxt");
            Expression baseUri = loader.getExpressionWithRole(element, "baseUri");
            Expression namespaceContext = loader.getExpressionWithRole(element, "nsCxt");
            Expression schemaAware = loader.getExpressionWithRole(element, "sa");
            Expression dynamicParams = loader.getExpressionWithRole(element, "wp");
            Expression optionsOp = loader.getExpressionWithRole(element, "options");
            EvaluateInstr inst = new EvaluateInstr(xpath, required, contextItem, baseUri, namespaceContext, schemaAware);
            if (optionsOp != null) {
                inst.setOptionsExpression(optionsOp);
            }
            if ((namespaces = element.getAttributeValue("", "schNS")) != null) {
                String[] uris;
                for (String uri : uris = namespaces.split(" ")) {
                    if (uri.equals("##")) {
                        uri = "";
                    }
                    inst.importSchemaNamespace(uri);
                }
            }
            NameTest test = new NameTest(1, "http://ns.saxonica.com/xslt/export", "withParam", loader.getConfiguration().getNamePool());
            AxisIterator kids = element.iterateAxis((byte)3, test);
            ArrayList<WithParam> nonTunnelParams = new ArrayList<WithParam>();
            int slotNumber = 0;
            while ((wp = kids.next()) != null) {
                WithParam withParam = new WithParam();
                StructuredQName paramName = loader.getQNameAttribute(wp, "name");
                withParam.setVariableQName(paramName);
                withParam.setSlotNumber(slotNumber++);
                SequenceType reqType = loader.parseSequenceType(wp, "as");
                withParam.setRequiredType(reqType);
                withParam.setSelectExpression(inst, loader.getFirstChildExpression(wp));
                nonTunnelParams.add(withParam);
            }
            inst.setActualParameters(nonTunnelParams.toArray(new WithParam[0]));
            if (dynamicParams != null) {
                inst.setDynamicParams(dynamicParams);
            }
            return inst;
        });
        eMap.put("fnCoercer", (loader, element) -> {
            SpecificFunctionType type = (SpecificFunctionType)loader.parseSequenceType(element, "to").getPrimaryType();
            RoleDiagnostic role = RoleDiagnostic.reconstruct(element.getAttributeValue("", "diag"));
            Expression arg = loader.getFirstChildExpression(element);
            return new FunctionSequenceCoercer(arg, type, role);
        });
        eMap.put("fnRef", (loader, element) -> {
            loader.needsPELicense("higher order functions");
            String name = element.getAttributeValue("", "name");
            int arity = loader.getIntegerAttribute(element, "arity");
            RetainedStaticContext rsc = loader.makeRetainedStaticContext(element);
            SystemFunction f = null;
            if (name.startsWith("Q{")) {
                String uri;
                StructuredQName qName = StructuredQName.fromEQName(name);
                switch (uri = qName.getURI()) {
                    case "http://www.w3.org/2005/xpath-functions/math": {
                        f = MathFunctionSet.getInstance().makeFunction(qName.getLocalPart(), arity);
                        break;
                    }
                    case "http://www.w3.org/2005/xpath-functions/map": {
                        f = MapFunctionSet.getInstance().makeFunction(qName.getLocalPart(), arity);
                        break;
                    }
                    case "http://www.w3.org/2005/xpath-functions/array": {
                        f = ArrayFunctionSet.getInstance().makeFunction(qName.getLocalPart(), arity);
                        break;
                    }
                    case "http://saxon.sf.net/": {
                        f = ((ProfessionalConfiguration)loader.getConfiguration()).getVendorFunctionSet().makeFunction(qName.getLocalPart(), arity);
                    }
                }
            } else {
                f = SystemFunction.makeFunction(name, rsc, arity);
            }
            if (f == null) {
                throw new XPathException("Unknown system function " + name + "#" + arity, "SXPK0002");
            }
            return new FunctionLiteral(f);
        });
        eMap.put("inlineFn", (loader, element) -> {
            NodeInfo first = loader.getChild(element, 0);
            UserFunction uf = loader.readFunction(first);
            return new UserFunctionReference(uf);
        });
        eMap.put("javaCall", (loader, element) -> {
            StructuredQName name = loader.getQNameAttribute(element, "name");
            Expression[] args = PackageLoaderPE.getChildExpressionArray(loader, element);
            loader.needsPELicense("Java extension functions");
            FunctionLibrary lib = ((ProfessionalConfiguration)loader.getConfiguration()).getExtensionBinder("java");
            SymbolicName.F sName = new SymbolicName.F(name, args.length);
            IndependentContext env = new IndependentContext(loader.getConfiguration());
            ArrayList<String> reasons = new ArrayList<String>();
            Expression exp = lib.bind(sName, args, env, reasons);
            if (exp == null) {
                StringBuilder msg = new StringBuilder("Failed to load Java extension function " + name.getEQName());
                for (String reason : reasons) {
                    msg.append(". ").append(reason);
                }
                throw new XPathException(msg.toString());
            }
            if (exp instanceof JavaExtensionLibrary.UnresolvedExtensionFunctionCall) {
                SequenceType[] argTypes = new SequenceType[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (element.getAttributeValue("", "arg" + i + "type") == null) {
                        throw new XPathException("SEF file needs to be re-exported using Saxon 9.7.0.12 or later: see bug 3019");
                    }
                    argTypes[i] = loader.parseSequenceType(element, "arg" + i + "type");
                }
                exp = ((JavaExtensionLibrary.UnresolvedExtensionFunctionCall)exp).resolve(argTypes);
            }
            if (exp instanceof JavaExtensionFunctionCall) {
                SequenceType returnType;
                ((JavaExtensionFunctionCall)exp).prepareForDynamicCall(loader.getConfiguration());
                String declaredType = element.getAttributeValue("", "declType");
                if (declaredType != null && (returnType = loader.parseSequenceType(element, "declType")).getPrimaryType() instanceof JavaExternalObjectType) {
                    ((JavaExtensionFunctionCall)exp).adjustRequiredType((JavaExternalObjectType)returnType.getPrimaryType());
                }
            }
            return exp;
        });
        eMap.put("origF", (loader, element) -> {
            StructuredQName name = loader.getQNameAttribute(element, "name");
            String packKey = element.getAttributeValue("", "pack");
            StylesheetPackage declPack = loader.allPackages.get(packKey);
            if (declPack == null) {
                throw new XPathException("Unknown package key " + packKey);
            }
            int arity = loader.getIntegerAttribute(element, "arity");
            SymbolicName.F sn = new SymbolicName.F(name, arity);
            Component target = declPack.getComponent(sn);
            OriginalFunction orig = new OriginalFunction(target);
            return new FunctionLiteral(orig);
        });
        eMap.put("partialApply", (loader, element) -> {
            NodeInfo child;
            AxisIterator iter = element.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            int count = 0;
            while ((child = iter.next()) != null) {
                ++count;
            }
            Expression base = null;
            Expression[] args = new Expression[count - 1];
            count = 0;
            iter = element.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((child = iter.next()) != null) {
                if (count == 0) {
                    base = loader.loadExpression(child);
                } else {
                    args[count - 1] = child.getLocalPart().equals("null") ? null : loader.loadExpression(child);
                }
                ++count;
            }
            return new PartialApply(base, args);
        });
        eMap.put("ufRef", (loader, element) -> {
            StructuredQName name = loader.getQNameAttribute(element, "name");
            int arity = loader.getIntegerAttribute(element, "arity");
            SymbolicName.F symbolicName = new SymbolicName.F(name, arity);
            UserFunctionReference call = new UserFunctionReference(symbolicName);
            int bindingSlot = loader.getIntegerAttribute(element, "bSlot");
            call.setBindingSlot(bindingSlot);
            loader.fixups.peek().add(call);
            return call;
        });
        eMap.put("while", (loader, element) -> {
            loader.needsPELicense("saxon:while");
            Expression lhs = loader.getFirstChildExpression(element);
            Expression rhs = loader.getSecondChildExpression(element);
            return new While(lhs, rhs);
        });
    }
}

