/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeCellRendererDelegator
implements TreeCellRenderer {
    Map<Class<?>, TreeCellRenderer> delegates;
    private TreeCellRenderer defaultRenderer;

    public TreeCellRendererDelegator() {
        this.defaultRenderer = this.createDefaultRenderer();
        this.delegates = new HashMap();
    }

    public TreeCellRendererDelegator(TreeCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
        this.delegates = new HashMap();
    }

    public TreeCellRendererDelegator(Map<Class<?>, TreeCellRenderer> delegates) {
        this.defaultRenderer = this.createDefaultRenderer();
        this.delegates = new HashMap(delegates);
    }

    public TreeCellRendererDelegator(Map<Class<?>, TreeCellRenderer> delegates, TreeCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
        this.delegates = new HashMap(delegates);
    }

    public void addRenderer(Class<?> clazz, TreeCellRenderer renderer) {
        this.delegates.put(clazz, renderer);
    }

    public TreeCellRenderer getRenderer(Class<?> clazz) {
        return this.delegates.get(clazz);
    }

    public void removeRenderer(Class<?> clazz) {
        this.delegates.remove(clazz);
    }

    public void setDefaultRenderer(TreeCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreeCellRenderer renderer = this.delegates.get(value.getClass());
        if (renderer == null) {
            renderer = this.defaultRenderer;
        }
        return renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected TreeCellRenderer createDefaultRenderer() {
        return new DefaultTreeCellRenderer();
    }
}

