/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.filechooser.FileDescription;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class E2EFileView
extends FileView {
    private HashMap<String, Icon> iconTable;
    private HashMap<String, String> descriptionTable;
    private HashMap<String, String> typeDescriptionTable;
    private HashMap<String, Boolean> traversableTable;
    private ImageIcon newFile;
    private ImageIcon unknownFile;
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();

    public E2EFileView() {
        this.iconTable = new HashMap();
        this.descriptionTable = new HashMap();
        this.typeDescriptionTable = new HashMap();
        this.traversableTable = new HashMap();
        this.registerIcon("wsdl", "ch/e2e/swing/filechooser/file.wsdl.gif");
        this.unknownFile = ImageLoader.loadIcon((String)"ch/e2e/swing/filechooser/file.unknown.gif", (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        this.newFile = ImageLoader.loadIcon((String)"ch/e2e/swing/filechooser/file.new.gif", (boolean)true, (ClassLoader)this.getClass().getClassLoader());
    }

    public void registerFileDescription(String fileExtension, FileDescription fileDescription) {
        Boolean traversable;
        String typeDescription;
        String description;
        fileExtension = fileExtension.toLowerCase();
        Icon icon = fileDescription.getIcon();
        if (icon != null) {
            this.iconTable.put(fileExtension, icon);
        }
        if ((description = fileDescription.getDescription()) != null) {
            this.descriptionTable.put(fileExtension, description);
        }
        if ((typeDescription = fileDescription.getTypeDescription()) != null) {
            this.typeDescriptionTable.put(fileExtension, typeDescription);
        }
        if ((traversable = fileDescription.isTraversable()) != null) {
            this.traversableTable.put(fileExtension, traversable);
        }
    }

    public void registerIcon(String fileExtension, String imageName) {
        this.registerIcon(fileExtension, imageName, E2EFileView.class.getClassLoader());
    }

    public void registerIcon(String fileExtension, String imageName, ClassLoader classLoader) {
        this.registerIcon(fileExtension, ImageLoader.loadIcon((String)imageName, (boolean)true, (ClassLoader)classLoader));
    }

    public void registerIcon(String fileExtension, Icon icon) {
        this.iconTable.put(fileExtension.toLowerCase(), icon);
    }

    @Override
    public Icon getIcon(File file) {
        Icon result;
        if (file.isDirectory()) {
            result = this.fileSystemView.getSystemIcon(file);
        } else {
            String extension = this.getExtension(file);
            result = this.iconTable.get(extension);
            if (result == null && !file.exists()) {
                result = this.newFile;
            }
            if (result == null) {
                result = this.fileSystemView.getSystemIcon(file);
                if (result == null) {
                    try {
                        File tmpFile = File.createTempFile("e2e", '.' + extension);
                        tmpFile.deleteOnExit();
                        FileWriter writer = new FileWriter(tmpFile);
                        writer.append("");
                        writer.close();
                        result = this.fileSystemView.getSystemIcon(tmpFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (result != null) {
                    this.iconTable.put(extension, result);
                }
            }
            if (result == null) {
                result = this.unknownFile;
            }
        }
        return result;
    }

    @Override
    public String getDescription(File f) {
        String description = this.descriptionTable.get(this.getExtension(f));
        if (description == null) {
            description = super.getDescription(f);
        }
        return description;
    }

    @Override
    public String getTypeDescription(File f) {
        String result = this.typeDescriptionTable.get(this.getExtension(f));
        if (result == null) {
            result = super.getTypeDescription(f);
        }
        return result;
    }

    @Override
    public Boolean isTraversable(File f) {
        Boolean result = this.traversableTable.get(this.getExtension(f));
        if (result == null) {
            result = super.isTraversable(f);
        }
        return result;
    }

    protected FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    protected void setFileSystemView(FileSystemView fileSystemView) {
        this.fileSystemView = fileSystemView;
    }

    private String getExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        String result = index == -1 ? filename : filename.substring(index + 1);
        return result.toLowerCase();
    }
}

