/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.document;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FileTextFieldDocument
extends PlainDocument {
    private static String SINGLE_FORBIDDEN_CHARS = "/\\|:*?<>\"";
    private static String MULTIPLE_FORBIDDEN_CHARS = "/\\:*?<>\"";
    private int maxLength = 256;
    private String forbiddenChars = SINGLE_FORBIDDEN_CHARS;
    private boolean mutlipleSelection = false;

    @Override
    public void insertString(int offset, String insert, AttributeSet attributes) throws BadLocationException {
        if (!this.mutlipleSelection && this.getLength() + insert.length() > this.maxLength) {
            Toolkit.getDefaultToolkit().beep();
        } else if (!this.checkCharacters(offset, insert)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.insertString(offset, insert, attributes);
        }
    }

    public void setMultipleSelection(boolean mutlipleSelection) {
        this.mutlipleSelection = mutlipleSelection;
        this.forbiddenChars = mutlipleSelection ? MULTIPLE_FORBIDDEN_CHARS : SINGLE_FORBIDDEN_CHARS;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    protected boolean checkCharacters(int offset, String insert) {
        boolean result = true;
        int length = insert.length();
        if (length > 0) {
            if (this.getLength() == 0 && insert.charAt(0) == ' ') {
                result = false;
            } else {
                for (int i = 0; i < length; ++i) {
                    if (this.forbiddenChars.indexOf(insert.charAt(i)) == -1) continue;
                    result = false;
                }
            }
        }
        return result;
    }
}

