/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.document;

import ch.e2e.swing.document.FileTextFieldDocument;
import java.io.File;
import javax.swing.text.BadLocationException;

public class DirectoryTextFieldDocument
extends FileTextFieldDocument {
    private static final int WINDOWS = 0;
    private static final int UNIX = 1;
    private static String FORBIDDEN_CHARS = "|*?<>\"";
    private static int system = File.separatorChar == '\\' ? 0 : 1;
    private boolean relative = false;

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    @Override
    protected boolean checkCharacters(int offset, String insert) {
        boolean result = true;
        int length = insert.length();
        if (length > 0) {
            if (offset == 0) {
                char firstChar = insert.charAt(0);
                boolean bl = firstChar == '/' || firstChar == '\\' ? !this.relative : (result = true);
            }
            if (this.relative && offset < 3 && offset + length > 1) {
                try {
                    String text = this.getText(0, offset) + insert;
                    result = !text.startsWith("../") && !text.startsWith("..\\");
                }
                catch (BadLocationException text) {
                    // empty catch block
                }
            }
            for (int i = 0; i < length && result; ++i) {
                char c = insert.charAt(i);
                if (FORBIDDEN_CHARS.indexOf(c) == -1) {
                    if (c != ':') continue;
                    switch (system) {
                        case 0: {
                            result = offset + i == 1 && !this.relative;
                            break;
                        }
                        case 1: {
                            result = false;
                        }
                    }
                    continue;
                }
                result = false;
            }
        }
        return result;
    }
}

