/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.EmptyBorder;

public class SelectSideLineBorder
extends EmptyBorder {
    private Color[] colors = new Color[4];

    public SelectSideLineBorder(Insets insets) {
        this(insets, Color.black);
    }

    public SelectSideLineBorder(Insets insets, Color color) {
        super(insets);
        this.colors[0] = color;
        this.colors[1] = color;
        this.colors[2] = color;
        this.colors[3] = color;
    }

    public SelectSideLineBorder(Insets insets, Color[] colors) {
        super(insets);
        this.colors[0] = colors[0];
        this.colors[1] = colors[1];
        this.colors[2] = colors[2];
        this.colors[3] = colors[3];
    }

    public SelectSideLineBorder(int top, int left, int bottom, int right) {
        this(new Insets(top, left, bottom, right), Color.black);
    }

    public SelectSideLineBorder(int top, int left, int bottom, int right, Color color) {
        this(new Insets(top, left, bottom, right), color);
    }

    public SelectSideLineBorder(int top, int left, int bottom, int right, Color[] colors) {
        this(new Insets(top, left, bottom, right), colors);
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public void setInsets(Insets insets) {
        this.top = insets.top;
        this.left = insets.left;
        this.bottom = insets.bottom;
        this.right = insets.right;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        Color col = graphics.getColor();
        if (this.top > 0) {
            graphics.setColor(this.colors[0]);
            graphics.fillRect(x, y, width, this.top);
        }
        if (this.left > 0) {
            graphics.setColor(this.colors[1]);
            graphics.fillRect(x, y, this.left, height);
        }
        if (this.bottom > 0) {
            graphics.setColor(this.colors[2]);
            graphics.fillRect(x, y + height - this.bottom, width, this.bottom);
        }
        if (this.right > 0) {
            graphics.setColor(this.colors[3]);
            graphics.fillRect(x + width - this.right, y, this.right, height);
        }
        graphics.setColor(col);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public void setBorderColors(Color[] colors) {
        this.colors = colors;
    }
}

