/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.MinimizeButton;
import ch.e2e.swing.TitleButton;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class WindowTitle
extends JPanel {
    private JLabel titleLabel;
    private MinimizeButton minimizeButton;
    private TitleButton closeButton;
    private boolean minimized;
    private ActionListener minimizeListener;
    private ActionListener expandListener;
    private boolean rounded;
    private Color activeBackground;
    private Color inactiveBackground;
    private Color activeForeground;
    private Color inactiveForeground;

    public WindowTitle(String title, Icon icon, boolean rounded) {
        this(title, icon, rounded, true);
    }

    public WindowTitle(String title, Icon icon, boolean rounded, boolean showButtons) {
        super(new GridBagLayout());
        this.rounded = rounded;
        this.minimized = false;
        this.createGui(title, icon, showButtons);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    WindowTitle.this.setMinimized(new ActionEvent(WindowTitle.this, 1001, "window.title.minimize"));
                }
            }
        });
        this.activeBackground = SystemColor.activeCaption;
        this.inactiveBackground = SystemColor.inactiveCaption;
        this.activeForeground = SystemColor.activeCaptionText;
        this.inactiveForeground = SystemColor.inactiveCaptionText;
        this.titleLabel.setForeground(this.inactiveForeground);
        this.setBackground(this.inactiveBackground);
    }

    public void setActiveBackground(Color activeBackground) {
        this.activeBackground = activeBackground;
        this.setBackground(activeBackground);
    }

    public void setActiveForeground(Color activeForeground) {
        this.activeForeground = activeForeground;
        this.titleLabel.setForeground(activeForeground);
    }

    public void setInactiveBackground(Color inactiveBackground) {
        this.inactiveBackground = inactiveBackground;
        this.setBackground(inactiveBackground);
    }

    public void setInactiveForeground(Color inactiveForeground) {
        this.inactiveForeground = inactiveForeground;
        this.titleLabel.setForeground(inactiveForeground);
    }

    public void setMinimized(boolean minimized) {
        if (minimized) {
            this.minimize();
        } else {
            this.expand();
        }
        this.minimized = minimized;
    }

    public void windowsLostFocus() {
        this.titleLabel.setForeground(this.inactiveForeground);
        this.setBackground(this.inactiveBackground);
    }

    public void windowsGainedFocus() {
        this.titleLabel.setForeground(this.activeForeground);
        this.setBackground(this.activeBackground);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void addCloseListener(ActionListener closeListener) {
        this.closeButton.addActionListener(closeListener);
    }

    public void addMinimizeListener(ActionListener minimizeListener) {
        this.minimizeListener = AWTEventMulticaster.add(this.minimizeListener, minimizeListener);
    }

    public void addExpandListener(ActionListener expandListener) {
        this.expandListener = AWTEventMulticaster.add(this.expandListener, expandListener);
    }

    private void createGui(String title, Icon icon, boolean showButtons) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        this.setOpaque(true);
        this.addTitleAndIcon(icon, c, title, showButtons);
        if (showButtons) {
            c.weightx = 1.0;
            c.anchor = 13;
            c.insets = new Insets(2, 2, 2, 0);
            JPanel buttonPanel = new JPanel(new GridLayout());
            this.add((Component)buttonPanel, c);
            this.minimizeButton = new MinimizeButton();
            buttonPanel.add((Component)this.minimizeButton, c);
            this.minimizeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowTitle.this.setMinimized(e);
                }
            });
            c.insets = new Insets(2, 1, 2, 2);
            c.weightx = 0.0;
            this.closeButton = new TitleButton(ImageLoader.loadIcon((String)"ch/e2e/swing/close.gif", (boolean)true, (ClassLoader)this.getClass().getClassLoader()));
            this.add((Component)this.closeButton, c);
        }
    }

    private void addTitleAndIcon(Icon icon, GridBagConstraints c, String title, boolean showButtons) {
        JLabel iconLabel = new JLabel(icon);
        this.add((Component)iconLabel, c);
        title = title == null ? "" : title;
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        if (this.rounded) {
            this.titleLabel.setBorder(new EmptyBorder(0, 4, 0, 0));
        } else {
            this.titleLabel.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
        c.weightx = showButtons ? 0.0 : 1.0;
        this.add((Component)this.titleLabel, c);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.height == 0) {
            size.height = 10;
        }
        int preferredWidth = this.titleLabel.getPreferredSize().width + 15;
        if (this.closeButton != null) {
            preferredWidth += this.closeButton.getPreferredSize().width;
        }
        if (this.minimizeButton != null) {
            preferredWidth += this.minimizeButton.getPreferredSize().width;
        }
        size.width = preferredWidth;
        return size;
    }

    public void setIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public void setMinimizeButtonVisible(boolean visible) {
        if (this.minimizeButton != null) {
            this.minimizeButton.setVisible(visible);
        }
    }

    public void setCloseButtonVisible(boolean visible) {
        this.closeButton.setVisible(visible);
    }

    private void setMinimized(ActionEvent action) {
        boolean bl = this.minimized = !this.minimized;
        if (this.minimized) {
            this.minimize(action);
        } else {
            this.expand(action);
        }
    }

    private void minimize(ActionEvent action) {
        this.minimize();
        if (this.minimizeListener != null) {
            this.minimizeListener.actionPerformed(action);
        }
    }

    private void minimize() {
        if (this.minimizeButton != null) {
            this.minimizeButton.setMaximizeIcon();
        }
    }

    private void expand(ActionEvent action) {
        this.expand();
        if (this.expandListener != null) {
            this.expandListener.actionPerformed(action);
        }
    }

    private void expand() {
        if (this.minimizeButton != null) {
            this.minimizeButton.setMinimizeIcon();
        }
    }
}

