/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.CellEditor;
import ch.e2e.swing.renderer.CellRenderer;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class Tree
extends JTree {
    private TreeSelectionModel selectionModel;
    private boolean setmodel = true;
    private boolean selectWithPopupTrigger = true;
    private Map<Class, TreeCellEditor> editors = new HashMap<Class, TreeCellEditor>();

    public Tree(AbstractTreeModel treeModel) {
        super(treeModel);
        RendererPreferences preferences = new RendererPreferences(treeModel);
        CellRenderer renderer = new CellRenderer(preferences);
        this.setCellRenderer(renderer);
        CellEditor editor = new CellEditor(this, preferences);
        this.setCellEditor(editor);
        this.addEventHandler();
        this.selectionModel = this.getSelectionModel();
    }

    public Tree(AbstractTreeModel treeModel, TreeCellRenderer cellRenderer) {
        this(new RendererPreferences(treeModel), cellRenderer);
    }

    public Tree(RendererPreferences preferences) {
        this(preferences, (TreeCellRenderer)new CellRenderer(preferences));
    }

    public Tree(RendererPreferences preferences, TreeCellRenderer cellRenderer) {
        super(preferences.getTreeModel());
        this.setCellRenderer(cellRenderer);
        this.addEventHandler();
        this.selectionModel = this.getSelectionModel();
        CellEditor editor = new CellEditor(this, preferences);
        this.setCellEditor(editor);
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expandAll(TreePath path) {
        this.expandAll(path, this.getModel());
    }

    protected void expandAll(TreePath path, TreeModel model) {
        this.expandPath(path);
        Object node = path.getLastPathComponent();
        int count = model.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            Object child = model.getChild(node, i);
            if (model.isLeaf(child)) continue;
            this.expandAll(path.pathByAddingChild(child), model);
        }
    }

    public void collapseAll(TreePath path) {
        this.collapseAll(path, this.getModel());
    }

    public void collapseAll(TreePath path, TreeModel model) {
        this.collapsePath(path);
        Object node = path.getLastPathComponent();
        int count = model.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            Object child = model.getChild(node, i);
            if (model.isLeaf(child)) continue;
            this.collapseAll(path.pathByAddingChild(child), model);
        }
    }

    @Override
    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (this.setmodel) {
            this.selectionModel = selectionModel;
        }
        super.setSelectionModel(selectionModel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setmodel = false;
        if (enabled) {
            this.setSelectionModel(this.selectionModel);
        } else {
            if (this.selectionModel == null) {
                this.selectionModel = this.getSelectionModel();
            }
            this.setSelectionModel(null);
        }
        super.setEnabled(enabled);
        this.setmodel = true;
    }

    public boolean isSelectWithPopupTrigger() {
        return this.selectWithPopupTrigger;
    }

    public void setSelectWithPopupTrigger(boolean selectWithPopupTrigger) {
        this.selectWithPopupTrigger = selectWithPopupTrigger;
    }

    private void addEventHandler() {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                Tree.this.doSelectionAction((AbstractTreeModel)Tree.this.treeModel, event);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                Tree.this.doMouseAction(event);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyLocation() == 4) {
                    if (e.getKeyChar() == '*') {
                        Tree.this.expandAll(Tree.this.getSelectionPath());
                    }
                    if (e.getKeyChar() == '-') {
                        Tree.this.collapseAll(Tree.this.getSelectionPath());
                    }
                }
            }
        });
    }

    private void doSelectionAction(AbstractTreeModel model, TreeSelectionEvent event) {
        ActionListener selectionAction = model.getSelectionAction(event);
        if (selectionAction != null) {
            selectionAction.actionPerformed(new ActionEvent(this, 1001, "TreeSelectionChanged"));
        }
    }

    private void doMouseAction(MouseEvent event) {
        AbstractTreeModel model = (AbstractTreeModel)this.treeModel;
        if (event.isPopupTrigger() || event.getButton() == 3) {
            int x = event.getX();
            int y = event.getY();
            TreePath path = this.getPathForLocation(x, y);
            this.checkSelectionPath(path);
            this.doPopupAction(path, model, x, y);
        } else if (event.getClickCount() == 2) {
            this.doExecuteAction(model, event.getX(), event.getY());
        }
    }

    private void checkSelectionPath(TreePath path) {
        boolean selected;
        boolean bl = selected = path != null && this.isPathSelected(path);
        if (!selected && this.selectWithPopupTrigger) {
            this.setSelectionPath(path);
        }
    }

    private void doExecuteAction(AbstractTreeModel model, int x, int y) {
        ActionListener action;
        TreePath path = this.getPathForLocation(x, y);
        if (path != null && this.isPathSelected(path) && (action = model.getExecuteAction(this.getSelectionPaths())) != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "TREE_EXECUTE_ACTION");
            action.actionPerformed(actionEvent);
        }
    }

    private void doPopupAction(TreePath treePath, AbstractTreeModel model, int x, int y) {
        if (treePath != null) {
            JPopupMenu popup;
            TreePath[] selectionPaths;
            TreePath selectionPath = null;
            if (this.selectWithPopupTrigger) {
                selectionPaths = this.getSelectionPaths();
                for (int i = 0; selectionPaths != null && i < selectionPaths.length && selectionPath == null; ++i) {
                    if (!selectionPaths[i].equals(treePath)) continue;
                    selectionPath = selectionPaths[i];
                }
            } else {
                selectionPath = treePath;
                selectionPaths = new TreePath[]{treePath};
            }
            if (selectionPath != null && (popup = model.getPopupMenu(selectionPaths)) != null) {
                popup.show(this, x, y);
            }
        }
    }

    public void refresh() {
        if (this.getModel().getRoot() != null) {
            List<TreePath> expandedRows = this.getExpandedRows();
            ((AbstractTreeModel)this.getModel()).refresh();
            if (!expandedRows.isEmpty()) {
                this.expandRows(expandedRows);
            }
        }
    }

    public List<TreePath> getExpandedRows() {
        TreePath rootPath = new TreePath(this.getModel().getRoot());
        Enumeration<TreePath> expandedPaths = this.getExpandedDescendants(rootPath);
        return expandedPaths == null ? Collections.emptyList() : Collections.list(expandedPaths);
    }

    public void expandRows(List<? extends TreePath> rows) {
        for (TreePath treePath : rows) {
            this.expandPath(treePath);
        }
    }

    public TreeCellEditor getEditor(Class clazz) {
        TreeCellEditor editor = null;
        if (clazz != null && (editor = this.editors.get(clazz)) == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length && editor == null; ++i) {
                editor = this.editors.get(interfaces[i]);
            }
            if (editor == null) {
                editor = this.getEditor(clazz.getSuperclass());
            }
        }
        return editor;
    }

    public void setEditor(Class clazz, TreeCellEditor editor) {
        this.editors.put(clazz, editor);
    }

    public void setToolTipsEnabled(boolean enabled) {
        if (enabled) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        String tooltip = path == null ? super.getToolTipText(event) : ((AbstractTreeModel)this.getModel()).getTooltip(path.getLastPathComponent());
        return tooltip;
    }
}

