/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.border.SmallBevelBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class MouseOverButton
extends JButton {
    private Dimension preferredSize;
    private CompoundBorder raisedBorder;
    private CompoundBorder loweredBorder;
    private boolean pressed = false;
    private Icon disabledIcon;
    private boolean enabledIfPressed = false;

    public MouseOverButton(Icon icon) {
        this(icon, null);
    }

    public MouseOverButton(String text) {
        this(text, null, null);
    }

    public MouseOverButton(String text, Icon icon) {
        this(text, icon, null);
    }

    public MouseOverButton(Icon icon, String toolTipText) {
        super(icon);
        this.initialize(toolTipText);
    }

    public MouseOverButton(String text, Icon icon, String toolTipText) {
        super(text, icon);
        this.initialize(toolTipText);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.preferredSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public boolean isEnabledIfPressed() {
        return this.enabledIfPressed;
    }

    public void setEnabledIfPressed(boolean enabledIfPressed) {
        this.enabledIfPressed = enabledIfPressed;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.enabledIfPressed) {
            this.setDisabledIcon(enabled ? this.getIcon() : this.disabledIcon);
        }
        super.setEnabled(enabled);
    }

    public void setPressed(boolean pressed) {
        this.setPressed(pressed, this.enabledIfPressed);
    }

    public void setPressed(boolean pressed, boolean enabledIfPressed) {
        this.enabledIfPressed = enabledIfPressed;
        this.pressed = pressed;
        if (pressed) {
            this.setBackground(new Color(153, 153, 153));
            this.setBorderPainted(true);
            this.setBorder(this.loweredBorder);
            this.disabledIcon = this.getDisabledIcon();
            if (!enabledIfPressed) {
                this.setDisabledIcon(this.getIcon());
            }
            this.setEnabled(enabledIfPressed);
        } else {
            this.setBackground(new Color(204, 204, 204));
            this.setBorderPainted(false);
            this.setEnabled(true);
            if (this.disabledIcon != null) {
                this.setDisabledIcon(this.disabledIcon);
            }
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public void setBorder(Border border) {
        if (this.raisedBorder == null) {
            super.setBorder(border);
        } else {
            this.raisedBorder = new CompoundBorder(new SmallBevelBorder(2), new EmptyBorder(3, 3, 3, 3));
            this.loweredBorder = new CompoundBorder(new SmallBevelBorder(1), new EmptyBorder(3, 3, 3, 3));
            if (this.isBorderPainted()) {
                if (this.pressed) {
                    super.setBorder(this.loweredBorder);
                } else {
                    super.setBorder(this.raisedBorder);
                }
            }
        }
    }

    @Override
    public void setMargin(Insets margin) {
        if (this.raisedBorder != null) {
            ((SmallBevelBorder)this.raisedBorder.getOutsideBorder()).setMargin(margin);
            ((SmallBevelBorder)this.loweredBorder.getOutsideBorder()).setMargin(margin);
        } else {
            super.setMargin(margin);
        }
    }

    private void initialize(String toolTipText) {
        this.setOpaque(false);
        this.raisedBorder = new CompoundBorder(new SmallBevelBorder(2), new EmptyBorder(3, 3, 3, 3));
        this.loweredBorder = new CompoundBorder(new SmallBevelBorder(1), new EmptyBorder(3, 3, 3, 3));
        this.setBorder(this.raisedBorder);
        this.setToolTipText(toolTipText);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.addMouseListener(new MouseEventHandler());
        this.doLayout();
        this.preferredSize = super.getPreferredSize();
        this.disabledIcon = this.getDisabledIcon();
    }

    private class MouseEventHandler
    extends MouseAdapter {
        private boolean mouseIn = false;

        private MouseEventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!MouseOverButton.this.pressed && MouseOverButton.this.isEnabled()) {
                MouseOverButton.this.setBorder(MouseOverButton.this.loweredBorder);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!MouseOverButton.this.pressed) {
                if (this.mouseIn && MouseOverButton.this.isEnabled()) {
                    MouseOverButton.this.setBorderPainted(true);
                    MouseOverButton.this.setBorder(MouseOverButton.this.raisedBorder);
                } else {
                    MouseOverButton.this.setBorderPainted(false);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!MouseOverButton.this.pressed && MouseOverButton.this.isEnabled()) {
                this.mouseIn = true;
                MouseOverButton.this.setBorderPainted(true);
                MouseOverButton.this.setBorder(MouseOverButton.this.raisedBorder);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseIn = false;
            if (!MouseOverButton.this.pressed) {
                MouseOverButton.this.setBorderPainted(false);
            }
        }
    }
}

