/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.gui.event.ValueChangedEvent;
import ch.e2e.gui.event.ValueChangedEventMulticaster;
import ch.e2e.gui.event.ValueChangedListener;
import ch.e2e.swing.InputValueField;
import ch.e2e.swing.document.GenericNumberFieldDocument;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class GenericInputNumberField<T extends Number>
extends JTextField
implements InputValueField,
DocumentListener {
    protected T increment;
    protected T minimum;
    protected T maximum;
    private T value;
    private T emptyValue;
    private T lastCorrectValue;
    private InputFieldListener inputFieldlistener;
    private ValueChangedListener valueChangedlistener;
    private boolean fireEvents = true;
    private boolean beepOnError = true;

    public GenericInputNumberField(GenericNumberFieldDocument<T> doc, T min, T max, T increment) {
        super(doc.getMaxDigits() + 4);
        this.setHorizontalAlignment(4);
        this.minimum = min;
        this.maximum = max;
        this.increment = increment;
        doc.addDocumentListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (GenericInputNumberField.this.value == null || !GenericInputNumberField.this.isInRange(GenericInputNumberField.this.value)) {
                    GenericInputNumberField.this.setContent(GenericInputNumberField.this.lastCorrectValue);
                    GenericInputNumberField.this.fireEvents();
                }
            }
        });
        this.setDocument(doc);
        this.initialize();
    }

    protected abstract boolean isNaN(T var1);

    protected abstract T newValue(T var1);

    protected abstract T increment(T var1);

    protected abstract T decrement(T var1);

    public T getValue() {
        return this.getNumberFieldDocument().getActualValue();
    }

    public void setValue(T value) {
        this.setContent(this.newValue(value));
    }

    @Override
    public boolean isMaximumReached() {
        T actualValue = this.getActualValue(this.minimum);
        return actualValue != null && this.maximum != null && ((Comparable)actualValue).compareTo(this.maximum) > -1;
    }

    @Override
    public boolean isMinimumReached() {
        T actualValue = this.getActualValue(this.maximum);
        return actualValue != null && this.minimum != null && ((Comparable)actualValue).compareTo(this.minimum) < 1;
    }

    @Override
    public void clear() {
        this.setText("");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.value = this.getNumberFieldDocument().getActualValue();
        if (this.isInRange(this.value)) {
            this.lastCorrectValue = this.value;
        }
        this.fireEvents();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireEvents();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.value = this.getNumberFieldDocument().getActualValue();
        if (this.isInRange(this.value)) {
            this.lastCorrectValue = this.value;
        }
        this.fireEvents();
    }

    private void fireEvents() {
        if (this.fireEvents) {
            this.fireEvents = false;
            this.fireInputField();
            this.fireValueChanged();
            this.fireEvents = true;
        }
    }

    @Override
    public Object getContent() {
        return this.isNaN(this.value) || this.value == null || this.value.equals(this.emptyValue) ? null : this.value;
    }

    @Override
    public void setContent(Object value) {
        this.fireEvents = false;
        if (this.value == null || !this.value.equals(value)) {
            this.value = (Number)value;
            if (value == null || value.equals(this.emptyValue)) {
                this.setText("");
            } else {
                this.getNumberFieldDocument().format(this.value);
            }
            if (this.value != null && this.isInRange(this.value)) {
                this.lastCorrectValue = this.value;
            }
            this.fireEvents = true;
            this.fireEvents();
        }
        this.fireEvents = true;
    }

    @Override
    public void up() {
        T actualValue = this.increment(this.getActualValue(this.minimum));
        if (this.isInRange(actualValue)) {
            this.setContent(actualValue);
        } else {
            System.out.println("actualValue is not in range");
        }
    }

    @Override
    public void down() {
        T actualValue = this.decrement(this.getActualValue(this.minimum));
        if (this.isInRange(actualValue)) {
            this.setContent(actualValue);
        } else {
            System.out.println("actualValue is not in range");
        }
    }

    public void setMaximumFractionDigits(int fractionDigits) {
        this.getNumberFieldDocument().setMaximumFractionDigits(fractionDigits);
    }

    public int getMaximumFractionDigits() {
        return this.getNumberFieldDocument().getMaximumFractionDigits();
    }

    public void setMinimumFractionDigits(int fractionDigits) {
        this.getNumberFieldDocument().setMinimumFractionDigits(fractionDigits);
    }

    public int getMinimumFractionDigits() {
        return this.getNumberFieldDocument().getMinimumFractionDigits();
    }

    public void setFractionDigits(int fractionDigits) {
        this.getNumberFieldDocument().setFractionDigits(fractionDigits);
    }

    public int getFractionDigits() {
        return this.getNumberFieldDocument().getFractionDigits();
    }

    public char getDecimalSeparator() {
        return this.getNumberFieldDocument().getDecimalSeparator();
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this.getNumberFieldDocument().setGroupingUsed(groupingUsed);
    }

    public boolean isGroupingUsed() {
        return this.getNumberFieldDocument().isGroupingUsed();
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.getNumberFieldDocument().setGroupingSeparator(groupingSeparator);
    }

    public void setGroupingSize(int groupingSize) {
        this.getNumberFieldDocument().setGroupingSize(groupingSize);
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.inputFieldlistener = InputFieldEventMulticaster.addListener(this.inputFieldlistener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.inputFieldlistener = InputFieldEventMulticaster.removeListener(this.inputFieldlistener, listener);
    }

    public void fireInputField() {
        if (this.inputFieldlistener != null) {
            this.inputFieldlistener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    public void setEmptyValue(T emptyValue) {
        this.emptyValue = emptyValue;
    }

    protected boolean isInRange(T value) {
        boolean inRange = true;
        if (this.minimum != null && ((Comparable)value).compareTo(this.minimum) < 0 || this.maximum != null && ((Comparable)value).compareTo(this.maximum) > 0) {
            if (this.beepOnError) {
                Toolkit.getDefaultToolkit().beep();
            }
            return false;
        }
        return inRange;
    }

    protected GenericNumberFieldDocument<T> getNumberFieldDocument() {
        return (GenericNumberFieldDocument)this.getDocument();
    }

    private T getActualValue(T defaultValue) {
        T actualValue;
        try {
            actualValue = this.getNumberFieldDocument().getActualValue();
            if (this.isNaN(actualValue)) {
                actualValue = this.emptyValue;
            }
        }
        catch (NumberFormatException e) {
            actualValue = defaultValue;
        }
        return actualValue;
    }

    @Override
    public void addValueChangedListener(ValueChangedListener listener) {
        this.valueChangedlistener = ValueChangedEventMulticaster.addListener(this.valueChangedlistener, listener);
    }

    @Override
    public void removeValueChangedListener(ValueChangedListener listener) {
        this.valueChangedlistener = ValueChangedEventMulticaster.removeListener(this.valueChangedlistener, listener);
    }

    public boolean isBeepOnError() {
        return this.beepOnError;
    }

    public void setBeepOnError(boolean beepOnError) {
        ((GenericNumberFieldDocument)this.getDocument()).setBeepOnError(beepOnError);
        this.beepOnError = beepOnError;
    }

    @Override
    public void fireValueChanged() {
        ValueChangedEvent event = new ValueChangedEvent(this, this.value);
        if (this.valueChangedlistener != null) {
            this.valueChangedlistener.valueChanged(event);
        }
    }

    public void setMinimum(T minimum) {
        this.minimum = minimum;
        this.getNumberFieldDocument().setMinimum(minimum);
        if (minimum != null && this.value != null && !this.isNaN(this.value) && ((Comparable)minimum).compareTo(this.value) > 0) {
            this.setContent(this.newValue(minimum));
        }
    }

    public void setMaximum(T maximum) {
        this.maximum = maximum;
        this.getNumberFieldDocument().setMaximum(maximum);
        if (maximum != null && this.value != null && !this.isNaN(this.value) && ((Comparable)maximum).compareTo(this.value) < 0) {
            this.setContent(this.newValue(maximum));
        }
    }

    protected void initialize() {
        boolean beepOnError = this.isBeepOnError();
        this.setBeepOnError(false);
        this.setEmptyValue(null);
        this.setContent(null);
        this.setGroupingUsed(false);
        this.setBeepOnError(beepOnError);
    }
}

