/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.Logging;
import ch.e2e.swing.WindowTitle;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class FloatingFrame
extends JPanel
implements Logging {
    private static final int RESIZE_AREA = 6;
    private Window parent;
    private HashMap<Window, JDialog> dialogs = new HashMap();
    private boolean packed;
    private JDialog floatingFrame;
    private Point mouseClickPoint;
    private Point mouseResizePoint;
    private WindowListener windowListener;
    private int heightDiff = 0;
    private int widthDiff = 0;
    private int minWidth = 0;
    private boolean minimized = false;
    private Dimension lastSize;
    private boolean docked;
    protected JPanel northPanel;
    protected JMenuBar menubar;
    protected JPanel contentPane;
    protected JPanel centerPanel;
    protected WindowTitle windowTitle;

    public FloatingFrame(Dialog parent) {
        this(parent, "", true);
    }

    public FloatingFrame(Dialog parent, String title) {
        this(parent, title, true);
    }

    public FloatingFrame(Dialog parent, String title, boolean packed) {
        this(parent, title, packed, false);
    }

    public FloatingFrame(Dialog parent, String title, boolean packed, boolean docked) {
        super(new BorderLayout());
        logger.entering(FloatingFrame.class.getName(), "FloatingFrame");
        this.floatingFrame = new JDialog(parent, title, false);
        this.initialize(parent, packed, title, docked);
    }

    public FloatingFrame(Frame parent) {
        this(parent, "", true);
    }

    public FloatingFrame(Frame parent, String title) {
        this(parent, title, true);
    }

    public FloatingFrame(Frame parent, String title, boolean packed) {
        this(parent, title, packed, false);
    }

    public FloatingFrame(Frame parent, String title, boolean packed, boolean docked) {
        super(new BorderLayout());
        logger.entering(FloatingFrame.class.getName(), "FloatingFrame");
        this.floatingFrame = new JDialog(parent, title, false);
        this.initialize(parent, packed, title, docked);
    }

    protected void initialize(Window parent, boolean packed, String title, boolean docked) {
        this.parent = parent;
        this.dialogs.put(parent, this.floatingFrame);
        this.packed = packed;
        this.docked = docked;
        this.floatingFrame.setResizable(!packed);
        this.floatingFrame.setUndecorated(true);
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBorder(new CompoundBorder(new BevelBorder(0), new EmptyBorder(1, 1, 1, 1)));
        ContentPaneMouseListener mouseListener = new ContentPaneMouseListener();
        this.contentPane.addMouseListener(mouseListener);
        this.contentPane.addMouseMotionListener(mouseListener);
        if (docked) {
            this.add((Component)this.contentPane, "Center");
        } else {
            this.floatingFrame.setContentPane(this.contentPane);
        }
        this.northPanel = new JPanel(new BorderLayout());
        this.windowTitle = new WindowTitle(title, null, false);
        this.northPanel.add((Component)this.windowTitle, "North");
        this.contentPane.add((Component)this.northPanel, "North");
        this.centerPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.centerPanel, "Center");
        this.addWindowListener();
    }

    public void setIconImage(Image iconImage) {
        if (this.windowTitle != null) {
            this.windowTitle.setIcon(new ImageIcon(iconImage));
        }
    }

    public void setTitleVisible(boolean visible) {
        if (this.windowTitle != null) {
            this.windowTitle.setVisible(visible);
        }
    }

    private void addWindowListener() {
        this.floatingFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (FloatingFrame.this.windowListener != null) {
                    FloatingFrame.this.windowListener.windowActivated(e);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (FloatingFrame.this.windowListener != null) {
                    FloatingFrame.this.windowListener.windowDeactivated(e);
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (FloatingFrame.this.windowListener != null) {
                    FloatingFrame.this.windowListener.windowOpened(e);
                }
            }
        });
        this.floatingFrame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                FloatingFrame.this.windowTitle.windowsGainedFocus();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                FloatingFrame.this.windowTitle.windowsLostFocus();
            }
        });
        this.windowTitle.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatingFrame.this.close();
            }
        });
        this.windowTitle.addMinimizeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatingFrame.this.minimize();
            }
        });
        this.windowTitle.addExpandListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatingFrame.this.expand();
            }
        });
        this.windowTitle.addMouseListener(new WindowTitleMouseListener());
        this.windowTitle.addMouseMotionListener(new WindowTitleMouseMotionListener());
    }

    private void expand() {
        this.minimized = false;
        this.centerPanel.setVisible(true);
        if (this.menubar != null) {
            this.menubar.setVisible(true);
        }
        if (this.windowListener != null) {
            this.windowListener.windowDeiconified(new WindowEvent(this.floatingFrame, 204));
        }
        if (this.lastSize == null) {
            this.floatingFrame.pack();
        } else {
            this.floatingFrame.setSize(this.lastSize);
            this.floatingFrame.doLayout();
        }
    }

    private void minimize() {
        this.minimized = true;
        this.lastSize = this.floatingFrame.getSize();
        this.centerPanel.setVisible(false);
        if (this.menubar != null) {
            this.menubar.setVisible(false);
        }
        this.floatingFrame.pack();
        this.floatingFrame.setSize(this.lastSize.width, this.floatingFrame.getSize().height);
        this.floatingFrame.doLayout();
        if (this.windowListener != null) {
            this.windowListener.windowIconified(new WindowEvent(this.floatingFrame, 203));
        }
    }

    private void close() {
        if (this.windowListener != null) {
            this.windowListener.windowClosing(new WindowEvent(this.floatingFrame, 201));
        }
        this.setVisible(false);
        if (this.windowListener != null) {
            this.windowListener.windowClosed(new WindowEvent(this.floatingFrame, 202));
        }
    }

    public void addWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    public void removeWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, this.windowListener);
    }

    public void addWindowFocusListener(WindowFocusListener listener) {
        this.floatingFrame.addWindowFocusListener(listener);
    }

    public void removeWindowFocusListener(WindowFocusListener listener) {
        this.floatingFrame.removeWindowFocusListener(listener);
    }

    public void addWindowStateListener(WindowStateListener listener) {
        this.floatingFrame.addWindowStateListener(listener);
    }

    public void removeWindowStateListener(WindowStateListener listener) {
        this.floatingFrame.removeWindowStateListener(listener);
    }

    @Override
    public Component add(Component comp) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.add(comp);
        }
        return result;
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.centerPanel != null) {
            this.centerPanel.add(comp, constraints);
        }
    }

    protected void internalAdd(Component comp, Object constraints) {
        super.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        if (this.centerPanel != null) {
            this.centerPanel.add(comp, constraints, index);
        }
    }

    @Override
    public Component add(Component comp, int index) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.add(comp, index);
        }
        return result;
    }

    @Override
    public Component add(String name, Component comp) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.add(name, comp);
        }
        return result;
    }

    @Override
    public synchronized void addContainerListener(ContainerListener l) {
        this.centerPanel.addContainerListener(l);
    }

    @Override
    public Component findComponentAt(Point p) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.findComponentAt(p);
        }
        return result;
    }

    @Override
    public Component findComponentAt(int x, int y) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.findComponentAt(x, y);
        }
        return result;
    }

    @Override
    public Component getComponent(int n) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.getComponent(n);
        }
        return result;
    }

    @Override
    public Component getComponentAt(Point p) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.getComponentAt(p);
        }
        return result;
    }

    @Override
    public Component getComponentAt(int x, int y) {
        Component result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.getComponentAt(x, y);
        }
        return result;
    }

    @Override
    public int getComponentCount() {
        int result = 0;
        if (this.centerPanel != null) {
            result = this.centerPanel.getComponentCount();
        }
        return result;
    }

    @Override
    public Component[] getComponents() {
        Component[] result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.getComponents();
        }
        return result;
    }

    @Override
    public void remove(Component comp) {
        if (this.centerPanel != null) {
            this.centerPanel.remove(comp);
        }
    }

    @Override
    public void remove(int index) {
        if (this.centerPanel != null) {
            this.centerPanel.remove(index);
        }
    }

    @Override
    public void removeAll() {
        if (this.centerPanel != null) {
            this.centerPanel.removeAll();
        }
    }

    @Override
    public void doLayout() {
        if (this.centerPanel != null) {
            this.centerPanel.doLayout();
        }
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.centerPanel != null) {
            this.centerPanel.setLayout(layout);
        }
    }

    @Override
    public LayoutManager getLayout() {
        LayoutManager result = null;
        if (this.centerPanel != null) {
            result = this.centerPanel.getLayout();
        }
        return result;
    }

    public void setParent(Window parent) {
        if (!this.parent.equals(parent)) {
            JDialog floatingFrame = this.dialogs.get(parent);
            if (floatingFrame == null) {
                if (parent instanceof Dialog) {
                    floatingFrame = new JDialog((Dialog)parent, this.floatingFrame.getTitle(), false);
                } else if (parent instanceof Frame) {
                    floatingFrame = new JDialog((Frame)parent, this.floatingFrame.getTitle(), false);
                }
                floatingFrame.setResizable(!this.packed);
                floatingFrame.setUndecorated(true);
                this.dialogs.put(parent, floatingFrame);
            }
            floatingFrame.setContentPane(this.contentPane);
            if (this.minimized) {
                this.centerPanel.setVisible(false);
            }
            floatingFrame.setBounds(this.floatingFrame.getBounds());
            floatingFrame.setVisible(true);
            this.floatingFrame.setVisible(false);
            this.floatingFrame = floatingFrame;
            this.parent = parent;
        }
    }

    protected Container getOriginalParent() {
        return super.getParent();
    }

    @Override
    public Container getParent() {
        Container parent = this.docked ? super.getParent() : this.parent;
        return parent;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.floatingFrame.setCursor(cursor);
    }

    @Override
    public void setBorder(Border border) {
        if (this.floatingFrame == null) {
            super.setBorder(border);
        } else if (this.contentPane == null) {
            super.setBorder(border);
        } else {
            this.contentPane.setBorder(border);
        }
    }

    public void setDocked(boolean docked) {
        this.docked = docked;
    }

    @Override
    public boolean isVisible() {
        return this.docked ? super.isVisible() : this.floatingFrame.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.docked) {
            super.setVisible(visible);
        } else {
            if (this.packed && visible) {
                this.floatingFrame.pack();
            }
            this.floatingFrame.setVisible(visible);
            if (visible) {
                this.widthDiff = this.floatingFrame.getSize().width - this.centerPanel.getSize().width;
                this.heightDiff = this.floatingFrame.getSize().height - this.centerPanel.getSize().height + 15;
                this.minWidth = this.windowTitle.getPreferredSize().width;
            } else {
                for (JDialog jDialog : this.dialogs.values()) {
                    jDialog.setVisible(false);
                }
            }
        }
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
    }

    public void pack() {
        this.floatingFrame.pack();
    }

    public void setResizable(boolean resizable) {
        this.floatingFrame.setResizable(resizable);
    }

    public boolean isResizable() {
        return this.floatingFrame.isResizable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.floatingFrame.setEnabled(enabled);
    }

    public void setGlassPane(Component glassPane) {
        this.floatingFrame.setGlassPane(glassPane);
    }

    public Component getGlassPane() {
        return this.floatingFrame.getGlassPane();
    }

    public void setJMenuBar(JMenuBar menubar) {
        if (this.menubar != null) {
            this.northPanel.remove(this.menubar);
        }
        this.menubar = menubar;
        if (this.menubar != null) {
            this.northPanel.add((Component)this.menubar, "South");
        }
    }

    public JMenuBar getJMenuBar() {
        return this.menubar;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (this.windowTitle != null) {
            Dimension titleSize = this.windowTitle.getMinimumSize();
            size.width = Math.max(size.width, titleSize.width);
            size.height = Math.max(size.height, titleSize.height);
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.windowTitle != null) {
            Dimension titleSize = this.windowTitle.getPreferredSize();
            size.width = Math.max(size.width, titleSize.width);
            size.height = Math.max(size.height, titleSize.height);
        }
        return size;
    }

    @Override
    public int getWidth() {
        return this.floatingFrame.getWidth();
    }

    @Override
    public int getX() {
        return this.floatingFrame.getX();
    }

    @Override
    public int getY() {
        return this.floatingFrame.getY();
    }

    @Override
    public Point getLocation(Point rv) {
        return this.floatingFrame.getLocation(rv);
    }

    @Override
    public int getHeight() {
        return this.floatingFrame.getHeight();
    }

    @Override
    public void setBounds(Rectangle r) {
        this.floatingFrame.setBounds(r);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.floatingFrame.setBounds(x, y, width, height);
    }

    @Override
    public Rectangle getBounds(Rectangle rv) {
        Rectangle bounds = this.floatingFrame.getBounds(rv);
        if (this.minimized && this.lastSize != null) {
            bounds.width = this.lastSize.width;
            bounds.height = this.lastSize.height;
        }
        return bounds;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = this.floatingFrame.getBounds();
        if (this.minimized && this.lastSize != null) {
            bounds.width = this.lastSize.width;
            bounds.height = this.lastSize.height;
        }
        return bounds;
    }

    @Override
    public Point getLocationOnScreen() {
        return this.floatingFrame.getLocationOnScreen();
    }

    @Override
    public Point getLocation() {
        return this.floatingFrame.getLocation();
    }

    @Override
    public void setLocation(Point p) {
        this.floatingFrame.setLocation(p);
    }

    @Override
    public void setLocation(int x, int y) {
        this.floatingFrame.setLocation(x, y);
    }

    @Override
    public Dimension getSize() {
        Dimension size = this.minimized && this.lastSize != null ? this.lastSize : this.floatingFrame.getSize();
        return size;
    }

    @Override
    public Dimension getSize(Dimension rv) {
        Dimension size = this.minimized && this.lastSize != null ? this.lastSize : this.floatingFrame.getSize(rv);
        return size;
    }

    @Override
    public void setSize(Dimension d) {
        this.floatingFrame.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        this.floatingFrame.setSize(width, height);
    }

    public void setTitle(String title) {
        this.windowTitle.setTitle(title);
    }

    @Override
    public JRootPane getRootPane() {
        return this.floatingFrame.getRootPane();
    }

    public void setMinimized(boolean minimized) {
        if (this.minimized ^ minimized) {
            this.minimized = minimized;
            this.centerPanel.setVisible(!minimized);
            this.windowTitle.setMinimized(minimized);
        }
    }

    private class WindowTitleMouseMotionListener
    extends MouseMotionAdapter {
        private WindowTitleMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (FloatingFrame.this.mouseClickPoint != null) {
                Point frameLocation = FloatingFrame.this.floatingFrame.getLocation();
                Point newMousePoint = e.getPoint();
                FloatingFrame.this.floatingFrame.setLocation(frameLocation.x + newMousePoint.x - ((FloatingFrame)FloatingFrame.this).mouseClickPoint.x, frameLocation.y + newMousePoint.y - ((FloatingFrame)FloatingFrame.this).mouseClickPoint.y);
            }
        }
    }

    private class WindowTitleMouseListener
    extends MouseAdapter {
        private WindowTitleMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FloatingFrame.this.mouseClickPoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FloatingFrame.this.mouseClickPoint = null;
        }
    }

    private class ContentPaneMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Cursor defaultCursor = new Cursor(0);
        private Cursor eastCursor = new Cursor(11);
        private Cursor southEastCursor = new Cursor(5);
        private Cursor southCursor = new Cursor(9);
        private Cursor southWestCursor = new Cursor(4);
        private Cursor westCursor = new Cursor(10);
        private int resizeType = 0;

        private ContentPaneMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FloatingFrame.this.mouseClickPoint = e.getPoint();
            FloatingFrame.this.mouseResizePoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FloatingFrame.this.mouseClickPoint = null;
            FloatingFrame.this.mouseResizePoint = null;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FloatingFrame.this.floatingFrame.setCursor(this.defaultCursor);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (FloatingFrame.this.floatingFrame.isResizable() && !FloatingFrame.this.minimized) {
                Cursor newCursor = this.defaultCursor;
                this.resizeType = 0;
                int x = e.getX();
                int y = e.getY();
                Dimension size = FloatingFrame.this.contentPane.getSize();
                if (x < 6) {
                    if (y > size.height - 6) {
                        newCursor = this.southWestCursor;
                        this.resizeType = 4;
                    } else {
                        newCursor = this.westCursor;
                        this.resizeType = 10;
                    }
                } else if (y >= 6) {
                    if (x > size.width - 6) {
                        if (y > size.height - 6) {
                            newCursor = this.southEastCursor;
                            this.resizeType = 5;
                        } else {
                            newCursor = this.eastCursor;
                            this.resizeType = 11;
                        }
                    } else if (y > size.height - 6) {
                        newCursor = this.southCursor;
                        this.resizeType = 9;
                    } else if (x > size.width - 6 && y > size.height - 6) {
                        newCursor = this.southEastCursor;
                        this.resizeType = 5;
                    }
                }
                FloatingFrame.this.floatingFrame.setCursor(newCursor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (FloatingFrame.this.floatingFrame.isResizable() && !FloatingFrame.this.minimized) {
                int xSign = 1;
                int ySign = 1;
                if (FloatingFrame.this.mouseResizePoint != null) {
                    Point newMousePoint;
                    switch (this.resizeType) {
                        case 6: {
                            ySign = -1;
                        }
                        case 4: 
                        case 10: {
                            xSign = -1;
                            break;
                        }
                        case 7: 
                        case 8: {
                            ySign = -1;
                        }
                    }
                    Rectangle frameBounds = FloatingFrame.this.floatingFrame.getBounds();
                    Point nextMousePoint = newMousePoint = e.getPoint();
                    if (this.checkWidthSetting()) {
                        nextMousePoint = this.setWidth(newMousePoint, xSign, frameBounds, nextMousePoint);
                    }
                    if (this.checkHeightSetting()) {
                        nextMousePoint = this.setHeight(newMousePoint, ySign, frameBounds, nextMousePoint);
                    }
                    FloatingFrame.this.mouseResizePoint = nextMousePoint;
                    FloatingFrame.this.floatingFrame.setBounds(frameBounds);
                }
            }
        }

        private Point setHeight(Point newMousePoint, int ySign, Rectangle frameBounds, Point nextMousePoint) {
            int heightDiff = ySign * (newMousePoint.y - ((FloatingFrame)FloatingFrame.this).mouseResizePoint.y);
            int newHeight = frameBounds.height + heightDiff;
            int minHeight = FloatingFrame.this.centerPanel.getMinimumSize().height + FloatingFrame.this.heightDiff;
            if (newHeight < minHeight) {
                newHeight = minHeight;
                nextMousePoint = null;
            } else if (ySign == -1 && nextMousePoint != null) {
                frameBounds.y = frameBounds.y + newMousePoint.y - ((FloatingFrame)FloatingFrame.this).mouseClickPoint.y;
                nextMousePoint.y = ((FloatingFrame)FloatingFrame.this).mouseResizePoint.y;
            }
            frameBounds.height = newHeight;
            return nextMousePoint;
        }

        private Point setWidth(Point newMousePoint, int xSign, Rectangle frameBounds, Point nextMousePoint) {
            int widthDiff = xSign * (newMousePoint.x - ((FloatingFrame)FloatingFrame.this).mouseResizePoint.x);
            int newWidth = frameBounds.width + widthDiff;
            int minWidth = Math.max(FloatingFrame.this.centerPanel.getMinimumSize().width, FloatingFrame.this.minWidth) + FloatingFrame.this.widthDiff;
            if (newWidth < minWidth) {
                newWidth = minWidth;
                nextMousePoint = null;
            } else if (xSign == -1) {
                frameBounds.x = frameBounds.x + newMousePoint.x - ((FloatingFrame)FloatingFrame.this).mouseClickPoint.x;
                nextMousePoint.x = ((FloatingFrame)FloatingFrame.this).mouseResizePoint.x;
            }
            frameBounds.width = newWidth;
            return nextMousePoint;
        }

        private boolean checkWidthSetting() {
            boolean setWidth = false;
            switch (this.resizeType) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    setWidth = true;
                }
            }
            return setWidth;
        }

        private boolean checkHeightSetting() {
            boolean setHeight = false;
            switch (this.resizeType) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    setHeight = true;
                }
            }
            return setHeight;
        }
    }
}

