/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.ModuleFactory;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.project.gui.NewProjectDialog;
import ch.e2e.event.EventExecuter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;

public class NewProjectExecuter
implements EventExecuter,
ProjectConstants {
    private NewProjectDialog projectDialog;
    private ProjectPool pool;
    private ModuleFactory moduleFactory;

    public NewProjectExecuter(ProjectPool pool, ModuleFactory moduleFactory) {
        this.pool = pool;
        this.moduleFactory = moduleFactory;
    }

    public void execute(EventObject event) {
        E2EBuilderProject newProject;
        if (this.projectDialog == null) {
            Collection<E2EBuilderModule> modules = this.moduleFactory.getModules();
            this.projectDialog = new NewProjectDialog(modules.iterator());
        }
        if ((newProject = this.projectDialog.createNewProject(this.pool.getProjectHome())) != null) {
            this.pool.saveProject();
            newProject.setNew(false);
            newProject.createProjectFolders();
            this.pool.setActualProject(newProject, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewProjectExecuter.this.pool.saveProject();
                }
            });
        }
    }
}

