/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.plugin.module;

import ch.e2e.builder.base.application.abstracts.SelectMenuItemEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.plugin.PluginConstants;
import ch.e2e.builder.base.plugin.gui.MainFrame;
import ch.e2e.builder.base.plugin.gui.MenuLabel;
import ch.e2e.builder.base.plugin.module.FloatingModuleFrame;
import ch.e2e.builder.base.plugin.module.ModuleFrame;
import ch.e2e.builder.base.plugin.module.ModuleFramePlugin;
import ch.e2e.builder.base.plugin.project.PluginProjectEvent;
import ch.e2e.builder.base.plugin.project.PluginProjectEventListener;
import ch.e2e.builder.base.plugin.project.PluginProjectManager;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventController;
import ch.e2e.util.StringTools;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.EventObject;
import java.util.Map;

public abstract class ModulePlugin
implements PluginConstants,
PluginProjectEventListener {
    private E2EBuilderModule module;
    private ModuleFrame moduleFrame;
    private MenuLabel menuLabel;
    private String mainApplicationVersion;

    public ModulePlugin(E2EBuilderModule module) {
        this.module = module;
        E2EBuilderTranslator.addTranslations((String)module.getName(), (String[])this.getTranslationProperties());
        String label = E2EBuilderTranslator.getTranslation((String)this.getMenuKey());
        String frameName = module.getTranslation(this.getFrameKey(), this.getFrameKey());
        label = StringTools.replaceProperty((String)label, (String)"module name", (String)frameName);
        this.menuLabel = new MenuLabel(label, this.getModule().getModuleInfo().getIcon());
        module.addProjectListener(new ProjectListener(){

            public void doBeforeChanging(ProjectEvent event) {
            }

            public void projectSettingsChange(ProjectEvent event) {
            }

            public void doBeforeProjectOpen(ProjectEvent event) {
            }

            public void doAfterProjectOpen(ProjectEvent event) {
            }

            public void projectOpened(ProjectEvent event) {
                if (ModulePlugin.this.moduleFrame != null) {
                    ModulePlugin.this.moduleFrame.setProjectName(event.getProject().getName());
                    ModulePlugin.this.moduleFrame.setVisibility(true);
                }
            }
        });
        PluginProjectManager.getInstance().addPluginProjectEventListener(this);
    }

    public void setModule(E2EBuilderModule module) {
        this.module = module;
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public abstract void initialize();

    public void guiInitialized() {
        this.setSizeAndVisibility();
    }

    public String[] getTranslationProperties() {
        return new String[]{this.getClass().getPackage().getName() + ".properties.translations"};
    }

    public void refresh() {
        this.module.refresh();
    }

    public boolean doAction(int key, Object data) {
        return true;
    }

    public void windowOpened() {
        this.getModule().show();
        this.getModule().activated();
    }

    public void windowClosed() {
        EventController.fire((EventObject)new SelectMenuItemEvent(this, null, new String[]{this.menuLabel.getLabel()}, false));
    }

    public ModuleFrame getModuleFrame() {
        return this.moduleFrame;
    }

    protected void setModuleFrame(ModuleFrame moduleFrame) {
        this.moduleFrame = moduleFrame;
    }

    public MenuLabel getMenuLabel() {
        return this.menuLabel;
    }

    public void closing() {
        if (this.moduleFrame != null) {
            if (this.moduleFrame instanceof MainFrame) {
                ((MainFrame)this.moduleFrame).saveStates();
            } else {
                Rectangle bounds = this.moduleFrame.getBounds();
                this.getModule().getProperties().setProperty("builder.plugin.frame.width", (long)bounds.width);
                this.getModule().getProperties().setProperty("builder.plugin.frame.height", (long)bounds.height);
                this.getModule().getProperties().setProperty("builder.plugin.frame.xpos", (long)bounds.x);
                this.getModule().getProperties().setProperty("builder.plugin.frame.ypos", (long)bounds.y);
            }
        }
    }

    public void closeWindow() {
        this.moduleFrame.setVisibility(false);
    }

    public void addVersionRuntimeProperties(Map properties, String mainApplicationVersion) {
        this.mainApplicationVersion = mainApplicationVersion;
        this.addRuntimeProperties(properties, mainApplicationVersion);
    }

    public String getMainApplicationVersion() {
        return this.mainApplicationVersion;
    }

    public void addRuntimeProperties(Map properties, String version) {
    }

    @Override
    public void projectActivated(PluginProjectEvent event) {
    }

    @Override
    public void projectClosed(PluginProjectEvent event) {
    }

    @Override
    public void projectDeActivated(PluginProjectEvent event) {
    }

    @Override
    public void projectOpened(PluginProjectEvent event) {
    }

    @Override
    public void projectReplaced(PluginProjectEvent event) {
    }

    @Override
    public void projectSaved(PluginProjectEvent event) {
    }

    public String getFrameKey() {
        return this.module.getShorttitle();
    }

    protected void setSizeAndVisibility() {
        EventController.fire((EventObject)new SelectMenuItemEvent(this, null, new String[]{this.menuLabel.getLabel()}, this.moduleFrame.isVisible()));
    }

    protected void setFloatingFrameBounds() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = new Rectangle();
        bounds.width = (int)this.getModule().getProperties().getInteger("builder.plugin.frame.width", (long)bounds.width);
        bounds.height = (int)this.getModule().getProperties().getInteger("builder.plugin.frame.height", (long)bounds.height);
        bounds.x = (int)this.getModule().getProperties().getInteger("builder.plugin.frame.xpos", (long)bounds.x);
        bounds.x = Math.max(0, bounds.x);
        bounds.x = Math.min(screenSize.width - 50, bounds.x);
        bounds.y = (int)this.getModule().getProperties().getInteger("builder.plugin.frame.ypos", (long)bounds.y);
        bounds.y = Math.max(0, bounds.y);
        bounds.y = Math.min(screenSize.height - 50, bounds.y);
        bounds.width = Math.min(bounds.width, screenSize.width - bounds.x);
        bounds.height = Math.min(bounds.height, screenSize.height - bounds.y);
        this.moduleFrame.setBounds(bounds);
    }

    public void createModuleFrame() {
        if (this instanceof ModuleFramePlugin) {
            this.moduleFrame = MainFrame.getMainFrame(this);
            ((MainFrame)this.moduleFrame).addModule(this);
        } else {
            this.moduleFrame = new FloatingModuleFrame(this);
        }
    }

    protected String getMenuKey() {
        String result = this instanceof ModuleFramePlugin ? "menu.module.mainframe.toggle" : "menu.module.floatingframe.toggle";
        return result;
    }
}

