/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.io;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.io.E2EBuilderFileChooser;
import ch.e2e.builder.base.io.E2EBuilderSaveFileChooser;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.IODialogConstants;
import ch.e2e.builder.base.project.gui.ProjectFileSystemView;
import ch.e2e.builder.base.project.gui.ProjectFileView;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.filechooser.DirectoryListChooser;
import ch.e2e.swing.model.FileListModelExtension;
import ch.e2e.swing.util.DirectoryFilter;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class FileService
implements IODialogConstants,
E2EBuilderIcons {
    private static HashMap<Window, E2EBuilderFileChooser> fileChoosers = new HashMap();
    private static HashMap<Window, E2EBuilderSaveFileChooser> saveFileChoosers = new HashMap();
    private static HashMap<Window, E2EBuilderFileChooser> directoryChoosers = new HashMap();
    private static HashMap<Window, E2EBuilderFileChooser> directoryNoProjectChoosers = new HashMap();
    private static HashMap<Window, DirectoryListChooser> directoryListChoosers = new HashMap();
    private static Dimension lastSize;

    public static File[] selectFiles(File startDir, String title, String subtitle) {
        return FileService.selectFiles(startDir, new E2EFileFilter[0], title, subtitle, true);
    }

    public static File[] selectFiles(File startDir, E2EFileFilter[] fileFilter, String title, String subtitle) {
        return FileService.selectFiles(startDir, fileFilter, title, subtitle, true);
    }

    public static File[] selectFiles(File startDir, E2EFileFilter[] fileFilter, String title, String subtitle, boolean includeAllFiles) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser fileChooser = FileService.getFileChooser(fileFilter, title, subtitle);
        File[] result = fileChooser.selectFiles(startDir, includeAllFiles);
        lastSize = fileChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFile(File startDir, String title, String subtitle) {
        return FileService.selectFile(startDir, new E2EFileFilter[0], title, subtitle, true);
    }

    public static File selectFile(File startDir, E2EFileFilter[] fileFilter, String title, String subtitle) {
        return FileService.selectFile(startDir, fileFilter, title, subtitle, true);
    }

    public static File selectFile(File startDir, File selectedFile, E2EFileFilter[] fileFilter, String title, String subtitle) {
        return FileService.selectFile(startDir, selectedFile, fileFilter, title, subtitle, true);
    }

    public static File selectFile(File startDir, E2EFileFilter[] fileFilter, String title, String subtitle, boolean includeAllFiles) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser fileChooser = FileService.getFileChooser(fileFilter, title, subtitle);
        File result = fileChooser.selectFile(startDir, includeAllFiles);
        lastSize = fileChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFile(File startDir, File selectedFile, E2EFileFilter[] fileFilter, String title, String subtitle, boolean includeAllFiles) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser fileChooser = FileService.getFileChooser(fileFilter, selectedFile, title, subtitle);
        File result = fileChooser.selectFile(startDir, selectedFile, includeAllFiles);
        lastSize = fileChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFile(File startDir, E2EFileFilter[] fileFilter, String title, String subtitle, boolean includeAllFiles, AbstractButton additionalButton, int index) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser fileChooser = FileService.getFileChooser(fileFilter, title, subtitle);
        if (index == -1) {
            fileChooser.addButton(additionalButton, 2);
        } else {
            fileChooser.insertButton(additionalButton, index);
        }
        File result = fileChooser.selectFile(startDir, includeAllFiles);
        fileChooser.removeButton(additionalButton);
        lastSize = fileChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFolder(File startDir, E2EFileFilter[] fileFilter, String title, String subtitle) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser directoryChooser = FileService.getDirectoryChooser();
        directoryChooser.setInternalTitle(title);
        directoryChooser.setSubtitle(subtitle);
        directoryChooser.setFileFilter(fileFilter, fileFilter[0]);
        File result = directoryChooser.selectDirectory(startDir);
        lastSize = directoryChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFolder(File startDir, String title, String subtitle) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser directoryChooser = FileService.getDirectoryChooser();
        directoryChooser.setInternalTitle(title);
        directoryChooser.setSubtitle(subtitle);
        File result = directoryChooser.selectDirectory(startDir);
        lastSize = directoryChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFolderNoProject(File startDir, File currentDir, String title, String internalTitle, String subtitle) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderFileChooser directoryChooser = FileService.getDirectoryNoProjectChooser();
        if (title != null) {
            directoryChooser.setTitle(title);
        }
        directoryChooser.setInternalTitle(internalTitle);
        directoryChooser.setSubtitle(subtitle);
        File result = directoryChooser.selectDirectory(startDir, currentDir);
        lastSize = directoryChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static File selectFolderFromList(File startDir, String title, String internalTitle, String subtitle) {
        return FileService.selectFolderFromList(startDir, null, title, internalTitle, subtitle, null, null);
    }

    public static File selectFolderFromList(File startDir, File preselection, String title, String internalTitle, String subtitle) {
        return FileService.selectFolderFromList(startDir, preselection, title, internalTitle, subtitle, null, null);
    }

    public static File selectFolderFromList(File startDir, File preselection, String title, String internalTitle, String subtitle, FileListModelExtension modelExtension) {
        return FileService.selectFolderFromList(startDir, preselection, title, internalTitle, subtitle, null, modelExtension);
    }

    public static File selectFolderFromList(File startDir, String title, String internalTitle, String subtitle, DirectoryFilter directoryFilter) {
        return FileService.selectFolderFromList(startDir, null, title, internalTitle, subtitle, directoryFilter, null);
    }

    public static File selectFolderFromList(File startDir, File preselection, String title, String internalTitle, String subtitle, DirectoryFilter directoryFilter) {
        return FileService.selectFolderFromList(startDir, preselection, title, internalTitle, subtitle, directoryFilter, null);
    }

    public static File selectFolderFromList(File startDir, String title, String internalTitle, String subtitle, DirectoryFilter directoryFilter, FileListModelExtension modelExtension) {
        return FileService.selectFolderFromList(startDir, null, title, internalTitle, subtitle, directoryFilter, modelExtension);
    }

    public static File selectFolderFromList(File startDir, File preselection, String title, String internalTitle, String subtitle, DirectoryFilter directoryFilter, FileListModelExtension modelExtension) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        DirectoryListChooser directoryListChooser = FileService.getDirectoryListChooser();
        directoryListChooser.setTitle(title);
        directoryListChooser.setInternalTitle(internalTitle);
        directoryListChooser.setSubtitle(subtitle);
        directoryListChooser.setModelExtension(modelExtension);
        directoryListChooser.setDirectoryFilter(directoryFilter);
        File result = directoryListChooser.selectDirectory(startDir, preselection);
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    private static DirectoryListChooser getDirectoryListChooser() {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        DirectoryListChooser directoryListChooser = directoryListChoosers.get(parent);
        if (directoryListChooser == null) {
            directoryListChooser = parent instanceof JFrame ? new DirectoryListChooser((JFrame)parent, "", "", "", E2EBUILDER_LOGO) : new DirectoryListChooser((JDialog)parent, "", "", "", E2EBUILDER_LOGO);
            directoryListChooser.setLocale(Locale.ENGLISH);
            directoryListChoosers.put(parent, directoryListChooser);
        }
        return directoryListChooser;
    }

    public static File saveFile(File selectedFile, E2EFileFilter[] fileFilter, String title, String subtitle, boolean includeAllFiles) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderSaveFileChooser saveFileChooser = FileService.getSaveFileChooser(E2EBuilder.getInstance().getDialogParent(), fileFilter, title, subtitle);
        return FileService.saveFile(saveFileChooser, selectedFile, includeAllFiles, parentFrame);
    }

    public static File saveFile(File selectedFile, E2EFileFilter[] fileFilter, E2EFileFilter selectedFileFilter, String title, String subtitle, boolean includeAllFiles) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderSaveFileChooser saveFileChooser = FileService.getSaveFileChooser(E2EBuilder.getInstance().getDialogParent(), fileFilter, title, subtitle);
        saveFileChooser.setFileFilter(selectedFileFilter);
        return FileService.saveFile(saveFileChooser, selectedFile, includeAllFiles, parentFrame);
    }

    private static File saveFile(E2EBuilderSaveFileChooser saveFileChooser, File selectedFile, boolean includeAllFiles, Frame parentFrame) {
        File result = saveFileChooser.saveFile(selectedFile, includeAllFiles);
        lastSize = saveFileChooser.getSize();
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    private static E2EBuilderSaveFileChooser getSaveFileChooser(Window parent, E2EFileFilter[] fileFilter, String title, String subtitle) {
        E2EBuilderSaveFileChooser saveFileChooser = saveFileChoosers.get(parent);
        if (saveFileChooser == null) {
            saveFileChooser = parent instanceof JFrame ? new E2EBuilderSaveFileChooser((JFrame)parent, title, subtitle) : new E2EBuilderSaveFileChooser((JDialog)parent, title, subtitle);
            saveFileChoosers.put(parent, saveFileChooser);
            saveFileChooser.setLocale(Locale.ENGLISH);
        }
        saveFileChooser.setFileFilter(fileFilter, fileFilter == null || fileFilter.length == 0 ? null : fileFilter[0]);
        saveFileChooser.setInternalTitle(title);
        saveFileChooser.setSubtitle(subtitle);
        if (lastSize != null) {
            saveFileChooser.setSize(lastSize);
        }
        return saveFileChooser;
    }

    private static E2EBuilderFileChooser createFileChooser() {
        E2EBuilderFileChooser fileChooser = E2EBuilderFileChooser.createFileChooser("", "");
        fileChooser.setLocale(Locale.ENGLISH);
        return fileChooser;
    }

    private static E2EBuilderFileChooser getFileChooser(E2EFileFilter[] fileFilter, String title, String subtitle) {
        return FileService.getFileChooser(fileFilter, null, title, subtitle);
    }

    private static E2EBuilderFileChooser getFileChooser(E2EFileFilter[] fileFilter, File selectedFile, String title, String subtitle) {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderFileChooser fileChooser = fileChoosers.get(parent);
        if (fileChooser == null) {
            fileChooser = FileService.createFileChooser();
            fileChoosers.put(parent, fileChooser);
        }
        E2EFileFilter selectedFileFilter = null;
        if (selectedFile != null && fileFilter.length > 1) {
            for (int i = 0; i < fileFilter.length && selectedFileFilter == null; ++i) {
                if (!fileFilter[i].accept(selectedFile)) continue;
                selectedFileFilter = fileFilter[i];
            }
        }
        if (fileFilter.length > 0) {
            fileChooser.setFileFilter(fileFilter, selectedFileFilter == null ? fileFilter[0] : selectedFileFilter);
        }
        fileChooser.setInternalTitle(title);
        fileChooser.setSubtitle(subtitle);
        if (lastSize != null) {
            fileChooser.setSize(lastSize);
        }
        return fileChooser;
    }

    private static E2EBuilderFileChooser getDirectoryChooser() {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderFileChooser directoryChooser = directoryChoosers.get(parent);
        if (directoryChooser == null) {
            directoryChooser = E2EBuilderFileChooser.createFileChooser(E2EBuilderTranslator.getTranslation((String)"directory.chooser.title"), "", "");
            directoryChooser.setLocale(Locale.ENGLISH);
            directoryChoosers.put(parent, directoryChooser);
        }
        if (lastSize != null) {
            directoryChooser.setSize(lastSize);
        }
        return directoryChooser;
    }

    private static E2EBuilderFileChooser getDirectoryNoProjectChooser() {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderFileChooser directoryChooser = directoryNoProjectChoosers.get(parent);
        if (directoryChooser == null) {
            ProjectFileSystemView fileSystemView = new ProjectFileSystemView();
            directoryChooser = E2EBuilderFileChooser.createFileChooser(FileSystemView.getFileSystemView().getHomeDirectory(), fileSystemView, E2EBuilderTranslator.getTranslation((String)"directory.chooser.title"), "", "");
            directoryChooser.setFileView((FileView)((Object)new ProjectFileView(fileSystemView)));
            directoryChooser.setLocale(Locale.ENGLISH);
            directoryNoProjectChoosers.put(parent, directoryChooser);
        }
        if (lastSize != null) {
            directoryChooser.setSize(lastSize);
        }
        return directoryChooser;
    }
}

