/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.menu;

import ch.e2e.builder.base.gui.menu.ActivatableItem;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.MenuItem;
import ch.e2e.swing.event.MenuEventObject;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class E2EBuilderMenuItem
extends MenuItem
implements ActivatableItem {
    String key;
    private boolean enabled = true;

    public E2EBuilderMenuItem(String key, Icon icon, MenuEventObject menuEvent) {
        super(icon, menuEvent);
        this.init(key);
    }

    E2EBuilderMenuItem(Icon icon, MenuEventObject menuEvent) {
        super(icon, menuEvent);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        super.setEnabled(enabled);
    }

    @Override
    public void setActivated(boolean activated) {
        super.setEnabled(activated && this.enabled);
    }

    void init(String key) {
        this.key = key;
        this.setText(this.getTranslation());
    }

    public void changeLanguage() {
        this.setText(this.getTranslation());
    }

    public void setText(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, ";", true);
        if (tokenizer.hasMoreTokens()) {
            super.setText(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
                this.setMnemonic(tokenizer);
                if (tokenizer.hasMoreTokens()) {
                    this.setAccelerator(KeyStroke.getKeyStroke(tokenizer.nextToken()));
                }
            }
        }
    }

    private void setMnemonic(StringTokenizer tokenizer) {
        String s;
        if (tokenizer.hasMoreTokens() && !(s = tokenizer.nextToken()).equals(";")) {
            this.setMnemonic(s.charAt(0));
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
        }
    }

    String getTranslation() {
        return E2EBuilderTranslator.getTranslation((String)this.key, (String)this.key);
    }
}

