/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.application.abstracts.ShowStatusEvent;
import ch.e2e.builder.base.gui.ImageCanvas;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.resource.ImageLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.EventObject;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow
implements EventExecuter {
    private ImageCanvas startScreen;

    public SplashScreen(ModuleInfo info) {
        Image image = ImageLoader.loadImage((String)"ch/e2e/builder/base/images/splashscreen.png", (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startScreen = new ImageCanvas(image);
        this.getContentPane().add(this.startScreen);
        Font versionFont = new Font("helvetica", 0, 12);
        Color textColor = new Color(0, 92, 128);
        Font statusFont = new Font("helvetica", 2, 12);
        this.startScreen.addLabel("Version " + info.getVersion(), "version", 10, 55, 100, 20, versionFont, textColor);
        this.startScreen.addLabel("", "status", 10, 280, 380, 20, statusFont, textColor);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int imagewidth = image.getWidth(this);
        int imageheight = image.getHeight(this);
        int x = (screensize.width - imagewidth) / 2;
        int y = (screensize.height - imageheight) / 2;
        this.setBounds(x, y, imagewidth, imageheight);
        EventController.register((EventExecuter)this, ShowStatusEvent.class);
    }

    public void close() {
        EventController.unregister((EventExecuter)this, ShowStatusEvent.class);
        this.setVisible(false);
        this.dispose();
    }

    public void execute(EventObject e) {
        ShowStatusEvent event = (ShowStatusEvent)e;
        this.setStatus(event.getMessage());
    }

    public void setStatus(String text) {
        this.startScreen.setText(text, "status");
    }
}

