/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageCanvas
extends JPanel {
    private Image image;
    private boolean scaling = false;
    private Color imageBackground;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private Graphics g;
    private int xPos;
    private int yPos;
    private int imageWidth;
    private int imageHeight;
    private HashMap<String, Text> labels = new HashMap();
    private boolean imageDrawn = false;

    public ImageCanvas(Image image) {
        super(new GridLayout(1, 1));
        this.image = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setLayout(null);
    }

    public void setImageBackground(Color imageBackground) {
        this.imageBackground = imageBackground;
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setText(String text, String name) {
        Text textLabel = this.labels.get(name);
        textLabel.label.setText(text);
    }

    public void addLabel(String text, String name, int x, int y, int width, int height, Font font, Color color) {
        Text textLabel = new Text(new JLabel(text), x, y, width, height, font, color);
        this.labels.put(name, textLabel);
        this.add(textLabel.label);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.createDimensions();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = this.scaling ? super.getPreferredSize() : new Dimension(this.imageWidth, this.imageHeight);
        return result;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.g = g;
        this.createDimensions();
        this.drawImage();
        this.drawLabels(g);
    }

    private void drawLabels(Graphics g) {
        for (Text text : this.labels.values()) {
            text.label.paint(g);
        }
    }

    private void createDimensions() {
        Dimension size = this.getSize();
        if (this.scaling) {
            this.imageWidth = size.width;
            this.imageHeight = size.height;
            this.xPos = 0;
            this.yPos = 0;
        } else {
            this.imageWidth = this.image.getWidth(this);
            this.imageHeight = this.image.getHeight(this);
            this.xPos = this.getX(size, this.imageWidth);
            this.yPos = this.getY(size, this.imageHeight);
        }
    }

    private void drawImage() {
        if (this.imageBackground != null) {
            this.g.setColor(this.imageBackground);
            this.g.fillRect(this.xPos, this.yPos, this.imageWidth, this.imageHeight);
        }
        this.g.drawImage(this.image, this.xPos, this.yPos, this.imageWidth, this.imageHeight, this);
        this.imageDrawn = true;
    }

    private void internalDrawText(Text text) {
        if (!this.imageDrawn || this.g != null) {
            // empty if block
        }
    }

    private int getX(Dimension size, int imageWidth) {
        int x;
        switch (this.horizontalAlignment) {
            case 0: {
                x = (size.width - imageWidth) / 2;
                break;
            }
            case 4: {
                x = size.width - imageWidth;
                break;
            }
            default: {
                x = 0;
            }
        }
        return x;
    }

    private int getY(Dimension size, int imageHeight) {
        int y;
        switch (this.verticalAlignment) {
            case 0: {
                y = (size.height - imageHeight) / 2;
                break;
            }
            case 4: {
                y = size.height - imageHeight;
                break;
            }
            default: {
                y = 0;
            }
        }
        return y;
    }

    private class Text {
        private int x;
        private int y;
        private int width;
        private int height;
        private JLabel label;

        public Text(JLabel label, int x, int y, int width, int height, Font font, Color color) {
            this.label = label;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            label.setFont(font);
            label.setForeground(color);
        }
    }
}

