/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.FileInputField;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.licensing.LicenseReader;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.InputTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class EnterLicenseDialog
extends E2EBuilderDialog {
    private static EnterLicenseDialog dialog;
    private InputTextArea licenseData;
    private FileInputField fileField;

    public EnterLicenseDialog() {
        super(E2EBuilderTranslator.getTranslation((String)"enter.license.title", (String)"enter.license.title"), E2EBuilderTranslator.getTranslation((String)"enter.license.internaltitle", (String)"enter.license.internaltitle"), E2EBuilderTranslator.getTranslation((String)"enter.license.subtitle", (String)"enter.license.subtitle"), 3);
        this.createGui();
    }

    public static String getLicense() {
        if (dialog == null) {
            dialog = new EnterLicenseDialog();
        }
        dialog.setOkButtonEnabled(false);
        String license = null;
        if (dialog.showDialog() == 1) {
            license = LicenseReader.getLicenseData(new StringReader(EnterLicenseDialog.dialog.licenseData.getText()));
            EnterLicenseDialog.dialog.licenseData.setText(license);
        }
        return license;
    }

    private void createGui() {
        this.setLayout(new BorderLayout(5, 3));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(this.createFileInput(), "North");
        JPanel center = new JPanel(new BorderLayout());
        center.add((Component)ComponentFactory.createLabel("enter.license.label.licensedata"), "North");
        this.licenseData = new InputTextArea(10, 50);
        this.licenseData.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                EnterLicenseDialog.this.dataChanged();
            }
        });
        center.add((Component)new JScrollPane((Component)this.licenseData, 20, 30), 1);
        this.add(center, 1);
    }

    private JPanel createFileInput() {
        JPanel fileInputPanel = new JPanel(new BorderLayout(5, 0));
        fileInputPanel.add((Component)ComponentFactory.createLabel("enter.license.label.licensefile"), "West");
        this.fileField = new FileInputField();
        this.fileField.setEditable(false);
        fileInputPanel.add((Component)((Object)this.fileField), "Center");
        JButton browse = ComponentFactory.createButton("enter.license.button.browse");
        fileInputPanel.add((Component)browse, "East");
        browse.addActionListener(new BrowseAction());
        return fileInputPanel;
    }

    private void dataChanged() {
        this.setOkButtonEnabled(this.licenseData.getText().length() > 0);
    }

    private class TextFileFilter
    extends E2EFileFilter {
        private String description = E2EBuilderTranslator.getTranslation((String)"enter.license.textfile.extension.description");

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDefaultExtension() {
            return "txt";
        }
    }

    private class BrowseAction
    implements ActionListener {
        private String title = E2EBuilderTranslator.getTranslation((String)"enter.license.browse.title", (String)"enter.license.browse.title");
        private String subtitle = E2EBuilderTranslator.getTranslation((String)"enter.license.browse.subtitle", (String)"enter.license.browse.subtitle");
        E2EFileFilter fileFilter;

        protected BrowseAction() {
            this.fileFilter = new TextFileFilter();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File startDir = EnterLicenseDialog.this.fileField.getContent().getParentFile();
            File file = FileService.selectFile(startDir, new E2EFileFilter[]{this.fileFilter}, this.title, this.subtitle);
            if (file != null) {
                EnterLicenseDialog.this.fileField.setContent(file);
                StringWriter license = new StringWriter();
                try {
                    FileUtilities.copy((Reader)new FileReader(file), (Writer)license);
                    EnterLicenseDialog.this.licenseData.setText(license.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

