/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.application.abstracts.SelectMenuItemEvent;
import ch.e2e.builder.base.event.ApplicationClosingEvent;
import ch.e2e.builder.base.event.E2EBuilderFrameEventHandler;
import ch.e2e.builder.base.event.MessageViewChangedEvent;
import ch.e2e.builder.base.event.MessageViewChangedListener;
import ch.e2e.builder.base.event.ToggleMessageViewEvent;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.gui.FrameConstants;
import ch.e2e.builder.base.gui.MessagePane;
import ch.e2e.builder.base.gui.MessagesParentWindow;
import ch.e2e.builder.base.gui.menu.E2EBuilderMenu;
import ch.e2e.builder.base.gui.menu.E2EBuilderMenuBar;
import ch.e2e.builder.base.gui.menu.OptionsMenu;
import ch.e2e.builder.base.gui.toolbar.E2EBuilderToolBar;
import ch.e2e.builder.base.licensing.CheckLicenseEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.ModuleFactory;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderStrings;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.StatusBar;
import ch.e2e.transaction.TransactionEvent;
import ch.e2e.transaction.TransactionException;
import ch.e2e.transaction.TransactionListener;
import ch.e2e.transaction.TransactionService;
import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.action.DockableBar;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.event.DockableFrameAdapter;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.EventObject;
import java.util.MissingResourceException;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class E2EBuilderFrame
extends DefaultDockableBarDockableHolder
implements ChangeListener,
MessageViewChangedListener,
TransactionListener,
FrameConstants,
ProjectListener,
E2EBuilderIcons,
E2EBuilderStrings,
MessagesParentWindow {
    private static final String[] PATH_VIEW_TOGGLE_MESSAGE_VIEW = new String[]{"menu.view", "menu.view.toggle.messageview"};
    private ModuleFactory moduleFactory;
    private JComponent overview;
    private MessagePane messages;
    private E2EBuilderModule activeModule;
    private Cursor cursor = Cursor.getDefaultCursor();
    private int waitCounter = 0;
    private StatusBar status;
    private E2EBuilderMenuBar menuBar;
    private E2EBuilderToolBar toolbar;
    private boolean refreshActivated;
    private String projectName = "";
    private String opening = "";
    private boolean transactionAllowed = true;
    private DockableFrame west;
    private DockableFrame south;
    private JComponent main;
    private String titlePrefix;

    public E2EBuilderFrame(E2EBuilderMenuBar menuBar, ModuleInfo applicationInfo) {
        super(applicationInfo.getShorttitle());
        this.titlePrefix = applicationInfo.getShorttitle();
        this.getLayoutPersistence().setUsePref(false);
        this.getLayoutPersistence().setLayoutDirectory(System.getProperty("user.home") + "/.e2ebuilder");
        this.getLayoutPersistence().setProfileKey("analyzer");
        this.getDockingManager().setShowInitial(false);
        this.menuBar = menuBar;
        E2EBuilderFrameEventHandler.initialize(this);
        this.setIconImages(E2EBuilder.getInstance().getApplicationIcons());
        this.addStatusBar();
        this.messages = new MessagePane(this);
        TransactionService.addTransactionListener((TransactionListener)this);
        this.opening = E2EBuilderTranslator.getTranslation((String)"project.opening");
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                E2EBuilderFrame.this.checkLicense();
            }
        }, CheckLicenseEvent.class);
    }

    private JComponent createMainPanel() {
        return new SingleComponentHolder();
    }

    private DockableFrame createOverviewDock() {
        DockableFrame frame = new DockableFrame("builder.overview");
        String title = E2EBuilderTranslator.getTranslation((String)"builder.overview", (String)"Overview");
        frame.setTitle(title);
        frame.setSideTitle(title);
        frame.setTabTitle(title);
        frame.setInitSide(8);
        frame.setInitIndex(0);
        frame.setHidable(false);
        return frame;
    }

    private DockableFrame createMessagesDock() {
        DockableFrame frame = new DockableFrame("builder.messages");
        String title = E2EBuilderTranslator.getTranslation((String)"builder.messages", (String)"Messages");
        frame.setTitle(title);
        frame.setSideTitle(title);
        frame.setTabTitle(title);
        frame.setInitSide(2);
        frame.setInitIndex(0);
        return frame;
    }

    public E2EBuilderToolBar getToolbar() {
        return this.toolbar;
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
        if (moduleFactory.getModuleCount() == 0) {
            this.showErrorAndExit();
        } else {
            this.createGui();
            this.addEventHandler();
            this.getLayoutPersistence().loadLayoutDataFrom("analyzer");
            if (this.messages.isEmpty()) {
                this.getDockingManager().hideFrame(this.south.getKey());
            }
            if (this.waitCounter > 0) {
                this.setComponentsEnabled(false);
                this.cursor = Cursor.getPredefinedCursor(3);
                super.setCursor(this.cursor);
            }
        }
    }

    private void createGui() {
        this.toolbar = new E2EBuilderToolBar(this.menuBar);
        this.getDockableBarManager().addDockableBar((DockableBar)this.toolbar);
        this.createViews();
        this.addModules();
        this.addMenuBar();
        this.activeModule.show();
    }

    private void addMenuBar() {
        this.menuBar.setModules(this.moduleFactory.getModules().iterator());
        this.menuBar.add((E2EBuilderMenu)new OptionsMenu((Container)((Object)this)), this.menuBar.getMenuCount() - 1);
        this.menuBar.addMenus();
        this.getDockableBarManager().addDockableBar((DockableBar)this.menuBar);
    }

    private void addStatusBar() {
        this.status = new StatusBar();
        this.status.addSection("status_messages");
        this.status.addIndeterminateProgressSection("status_busy");
        this.status.addSection("status_modified", 60);
        this.status.showTime("dd.MM.yyyy HH:mm", 60000);
        this.add((Component)this.status, "South");
    }

    public void showStatus(String text, String section) {
        this.status.setText(text, section);
    }

    public void transactionStart(TransactionEvent event) {
        if (!this.transactionAllowed) {
            throw new RuntimeException("No transactions allowed during changing the Modules in the view. Please overwrite method 'public void activated()'");
        }
        this.setWaitCursor();
    }

    public void transactionEnd(TransactionEvent event) {
        this.doTransactionEnd();
    }

    public void transactionFailed(TransactionException tEx) {
        this.doTransactionEnd();
    }

    private void doTransactionEnd() {
        this.setDefaultCursor();
    }

    public void setWaitCursor() {
        ++this.waitCounter;
        if (this.waitCounter == 1) {
            this.refreshActivated = false;
            this.cursor = Cursor.getPredefinedCursor(3);
            super.setCursor(this.cursor);
            this.setComponentsEnabled(false);
            this.status.start("status_busy");
        }
    }

    public void setDefaultCursor() {
        if (this.waitCounter > 0) {
            --this.waitCounter;
            if (this.waitCounter == 0) {
                if (this.refreshActivated) {
                    this.activateActiveModule();
                }
                this.cursor = Cursor.getDefaultCursor();
                super.setCursor(this.cursor);
                this.setComponentsEnabled(true);
                this.status.stop("status_busy");
            }
        }
    }

    private void setComponentsEnabled(boolean enabled) {
        if (this.overview != null) {
            this.overview.setEnabled(enabled);
        }
        if (this.activeModule != null) {
            this.activeModule.getOverviewPanel().setEnabled(enabled);
            this.activeModule.getMainPanel().setEnabled(enabled);
            this.menuBar.setEnabled(enabled);
            this.toolbar.setEnabled(this.menuBar);
        }
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public void setVisibility(boolean visible) {
        this.setMessagesVisible(true);
    }

    public void windowActivated() {
        if (this.waitCounter == 0) {
            this.activateActiveModule();
        } else {
            this.refreshActivated = true;
        }
    }

    private void activateActiveModule() {
        if (this.activeModule != null) {
            this.activeModule.applicationWindowActivated();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ((JideTabbedPane)this.overview).removeChangeListener((ChangeListener)this);
        int index = ((JideTabbedPane)this.overview).getSelectedIndex();
        if (index != -1) {
            String moduleName = ((JideTabbedPane)this.overview).getTitleAt(index);
            if (this.activeModule.remove()) {
                E2EBuilderModule newModule = this.moduleFactory.getModule(moduleName);
                boolean moduleChanged = false;
                this.transactionAllowed = false;
                if (newModule.show()) {
                    moduleChanged = true;
                    E2EBuilderModule oldModule = this.activeModule;
                    this.activeModule = newModule;
                    E2EBuilder.getInstance().setActiveModule(this.activeModule);
                    this.showActiveModule();
                    oldModule.removed();
                }
                this.transactionAllowed = true;
                if (moduleChanged) {
                    this.activeModule.activated();
                }
            }
            ((JideTabbedPane)this.overview).setSelectedComponent((Component)this.activeModule.getOverviewPanel());
        }
        this.showStatus("", "status_messages");
        ((JideTabbedPane)this.overview).addChangeListener((ChangeListener)this);
    }

    public void doBeforeChanging(ProjectEvent event) {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
        this.projectName = this.projectName(event);
        if (this.activeModule != null) {
            this.setTitle(this.titlePrefix + " - " + this.activeModule.getTitle() + ": " + this.opening + this.projectName);
        }
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
        this.projectName = this.projectName(event);
        if (this.activeModule != null) {
            this.setTitle(this.titlePrefix + " - " + this.activeModule.getTitle() + this.projectName);
        }
    }

    public void projectSettingsChange(ProjectEvent event) {
        String projectName = this.projectName(event);
        if (!projectName.equals(this.projectName) && this.activeModule != null) {
            this.projectName = projectName;
            this.setTitle(this.titlePrefix + " - " + this.activeModule.getTitle() + projectName);
        }
    }

    private String projectName(ProjectEvent event) {
        E2EBuilderProject project = event.getProject();
        return project.getProjectHome() == null ? "" : ": " + project.getName();
    }

    private void showActiveModule() {
        this.main.add(this.activeModule.getMainPanel());
        E2EBuilder.getInstance().getProperties().setProperty("last_module", this.activeModule.getTitle());
        this.messages.setActiveModule(this.activeModule.getName());
        this.setTitle(this.titlePrefix + " - " + this.activeModule.getTitle() + this.projectName);
        if (this.south.isHidden()) {
            this.setMessagesVisible(!this.messages.isEmpty());
        }
    }

    private void setMessagesVisible(boolean visible) {
        if (visible) {
            this.getDockingManager().showFrame(this.south.getKey());
        } else {
            this.getDockingManager().hideFrame(this.south.getKey());
        }
        EventController.fire((EventObject)new SelectMenuItemEvent(this, null, new String[]{"menu.view", "menu.view.toggle.messageview"}, visible));
    }

    @Override
    public void messageViewChanged(MessageViewChangedEvent event) {
        this.setMessagesVisible(!this.messages.isEmpty());
    }

    private void addModules() {
        if (this.moduleFactory.getModuleCount() > 1) {
            this.overview = new JideTabbedPane(1, 1);
            this.activeModule = this.createMultiModuleView();
            for (E2EBuilderModule module : this.moduleFactory.getModules()) {
                this.messages.registerModule(module.getName());
            }
            this.initializeActiveModule();
        } else {
            this.activeModule = this.moduleFactory.getModules().iterator().next();
            this.overview = this.activeModule.getOverviewPanel();
            this.main.add(this.activeModule.getMainPanel());
            this.setTitle(this.titlePrefix + " - " + this.activeModule.getTitle() + this.projectName);
            this.messages.setActiveModule(this.activeModule.getName());
        }
        E2EBuilder.getInstance().setActiveModule(this.activeModule);
        this.west.add((Component)this.overview);
    }

    private E2EBuilderModule createMultiModuleView() {
        String lastModule;
        E2EBuilderModule module2;
        String firstModule = null;
        TreeMap<Integer, E2EBuilderModule> tabOrderedModules = new TreeMap<Integer, E2EBuilderModule>();
        for (E2EBuilderModule module2 : this.moduleFactory.getModules()) {
            tabOrderedModules.put(module2.getModuleInfo().getTabOrder(), module2);
        }
        for (E2EBuilderModule module2 : tabOrderedModules.values()) {
            if (firstModule == null) {
                firstModule = module2.getTitle();
            }
            ((JideTabbedPane)this.overview).addTab(module2.getTitle(), (Component)module2.getOverviewPanel());
        }
        try {
            lastModule = E2EBuilder.getInstance().getProperties().getString("last_module");
        }
        catch (MissingResourceException mrEx) {
            lastModule = ((JideTabbedPane)this.overview).getTitleAt(0);
        }
        module2 = this.moduleFactory.getModule(lastModule);
        if (module2 == null) {
            E2EBuilder.getInstance().getProperties().setProperty("last_module", firstModule);
            module2 = this.moduleFactory.getModule(firstModule);
        }
        return module2;
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                E2EBuilderFrame.this.getLayoutPersistence().saveLayoutDataAs("analyzer");
            }
        }, ApplicationClosingEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                E2EBuilderFrame.this.setMessagesVisible(((ToggleMessageViewEvent)((Object)event)).getState());
            }
        }, ToggleMessageViewEvent.class);
        if (this.overview instanceof JideTabbedPane) {
            ((JideTabbedPane)this.overview).addChangeListener((ChangeListener)this);
        }
        this.messages.addMessageViewChangedListener(this);
    }

    private void createViews() {
        this.getDockingManager().beginLoadLayoutData();
        this.west = this.createOverviewDock();
        this.getDockingManager().addFrame(this.west);
        this.south = this.createMessagesDock();
        this.south.add((Component)this.messages);
        this.south.addDockableFrameListener((DockableFrameListener)new DockableFrameAdapter(){

            public void dockableFrameHidden(DockableFrameEvent dockableFrameEvent) {
                E2EBuilderFrame.this.menuBar.setItemSelected(PATH_VIEW_TOGGLE_MESSAGE_VIEW, false);
                E2EBuilderFrame.this.toolbar.setItemSelected(PATH_VIEW_TOGGLE_MESSAGE_VIEW, false);
            }
        });
        this.getDockingManager().addFrame(this.south);
        this.main = this.createMainPanel();
        this.getDockingManager().getWorkspace().add((Component)this.main, (Object)"Center");
    }

    private void showErrorAndExit() {
        String error = E2EBuilderTranslator.getTranslation((String)"no.module.error", (String)"no.module.error");
        E2EBuilderInfoDialog.error(error);
        System.exit(-1);
    }

    private void checkLicense() {
        int moduleCount = this.moduleFactory.getModuleCount();
        if (moduleCount == 1) {
            this.activeModule = this.moduleFactory.getModules().iterator().next();
            this.overview = this.activeModule.getOverviewPanel();
            this.main.add(this.activeModule.getMainPanel());
            this.showActiveModule();
        } else if (moduleCount > 0) {
            ((JideTabbedPane)this.overview).removeChangeListener((ChangeListener)this);
            int tabCount = ((JideTabbedPane)this.overview).getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                ((JideTabbedPane)this.overview).removeTabAt(0);
            }
            this.createMultiModuleView();
            this.initializeActiveModule();
            ((JideTabbedPane)this.overview).addChangeListener((ChangeListener)this);
        }
        this.getDockingManager().showInitial();
    }

    private void initializeActiveModule() {
        this.showActiveModule();
        this.activeModule.activated();
        int index = -1;
        for (int i = 0; i < ((JideTabbedPane)this.overview).getTabCount() && index == -1; ++i) {
            if (!((JideTabbedPane)this.overview).getTitleAt(i).equals(this.activeModule.getTitle())) continue;
            index = i;
        }
        ((JideTabbedPane)this.overview).setSelectedIndex(index);
    }

    private class SingleComponentHolder
    extends JComponent {
        private SingleComponentHolder() {
            this.setLayout(new BorderLayout());
        }

        @Override
        public void addImpl(Component comp, Object constraints, int index) {
            if (this.getComponentCount() > 0) {
                this.remove(0);
            }
            super.addImpl(comp, constraints, -1);
            this.revalidate();
            this.repaint();
        }
    }
}

