/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.examples;

import ch.e2e.builder.base.examples.ExampleEntry;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.project.ProjectFile;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.resource.Properties;
import ch.e2e.swing.InputCheckBox;
import ch.e2e.swing.InputTextField;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.document.DirectoryTextFieldDocument;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.CellRenderer;
import ch.e2e.swing.renderer.RendererPreferences;
import ch.e2e.util.StringTools;
import com.jidesoft.swing.CheckBoxTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ExtractExamplesDialog
extends E2EBuilderDialog {
    private JFileChooser exampleFileChooser;
    private JFileChooser exampleFolderChooser;
    private CheckBoxTree tree;
    private TreeModel treeModel;
    private InputTextField directoryField;
    private File examplesInstallationFolder;
    private InputCheckBox openProject;

    public ExtractExamplesDialog() {
        super(E2EBuilderTranslator.getTranslation((String)"examples.installation.dialog.title"), E2EBuilderTranslator.getTranslation((String)"examples.installation.dialog.internalTitle"), E2EBuilderTranslator.getTranslation((String)"examples.installation.dialog.subtitle"), 3);
        this.createGui();
    }

    public List<ExampleEntry> selectExamples(File examplesInstallationFolder) {
        List result = null;
        this.examplesInstallationFolder = examplesInstallationFolder;
        this.directoryField.setText(examplesInstallationFolder.getAbsolutePath());
        this.expandAll();
        if (this.showDialog() == 1 && this.tree.getCheckBoxTreeSelectionModel().getSelectionPaths() != null) {
            TreePath[] selection = this.tree.getCheckBoxTreeSelectionModel().getSelectionPaths();
            if (selection.length == 0) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList();
                for (TreePath treePath : selection) {
                    if (treePath.getLastPathComponent() instanceof ExampleEntry) {
                        result.add((ExampleEntry)treePath.getLastPathComponent());
                        continue;
                    }
                    if (!(treePath.getLastPathComponent() instanceof ExampleFolder)) continue;
                    result.addAll(this.getExamples((ExampleFolder)treePath.getLastPathComponent()));
                }
            }
        }
        return result;
    }

    private List<ExampleEntry> getExamples(ExampleFolder container) {
        ArrayList<ExampleEntry> result = new ArrayList<ExampleEntry>();
        for (ExampleFolder subContainer : container.containers) {
            result.addAll(this.getExamples(subContainer));
        }
        result.addAll(container.examples);
        return result;
    }

    public File getExamplesInstallationFolder() {
        return new File(this.directoryField.getText());
    }

    public boolean isOpenAfterInstallation() {
        return this.openProject.isSelected();
    }

    public int getMinimumWidth() {
        return 600;
    }

    private void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private List<TreePath> getExpandedRows() {
        TreePath rootPath = new TreePath(this.tree.getModel().getRoot());
        Enumeration expandedPaths = this.tree.getExpandedDescendants(rootPath);
        return expandedPaths == null ? Collections.emptyList() : Collections.list(expandedPaths);
    }

    private void expandRows(List<? extends TreePath> rows) {
        for (TreePath treePath : rows) {
            this.tree.expandPath(treePath);
        }
    }

    private void createGui() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel north = new JPanel(new BorderLayout());
        JLabel installationFolder = ComponentFactory.createLabel("examples.installation.folder");
        north.add((Component)installationFolder, "North");
        JPanel northCenter = new JPanel(new BorderLayout());
        this.directoryField = new InputTextField();
        this.directoryField.setDocument((Document)new DirectoryTextFieldDocument());
        northCenter.add((Component)this.directoryField, "Center");
        JButton browse = new JButton("...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractExamplesDialog.this.selectExamplesInstallationFolder();
            }
        });
        northCenter.add((Component)browse, "East");
        north.add((Component)northCenter, "Center");
        north.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(north, "North");
        this.treeModel = new TreeModel();
        this.tree = new CheckBoxTree((javax.swing.tree.TreeModel)((Object)this.treeModel));
        ExampleTreeCellRenderer renderer = new ExampleTreeCellRenderer(this.treeModel);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getCheckBoxTreeSelectionModel().setSelectionMode(4);
        this.tree.setClickInCheckBoxOnly(false);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add(scrollPane, "Center");
        this.openProject = ComponentFactory.createCheckBox("examples.installation.checkbox.open.after.install", null);
        this.openProject.setSelected(true);
        this.add((Component)this.openProject, "South");
    }

    private void selectExamplesInstallationFolder() {
        List<TreePath> rows = this.getExpandedRows();
        File examplesFolder = FileService.selectFolderNoProject(this.examplesInstallationFolder, this.examplesInstallationFolder, E2EBuilderTranslator.getTranslation((String)"examples.installation.folder.selection.title"), E2EBuilderTranslator.getTranslation((String)"examples.installation.folder.selection.internaltitle"), E2EBuilderTranslator.getTranslation((String)"examples.installation.folder.selection.subtitle"));
        if (examplesFolder != null) {
            this.examplesInstallationFolder = examplesFolder;
            this.directoryField.setText(this.examplesInstallationFolder.getAbsolutePath());
            this.treeModel.refresh();
            this.expandRows(rows);
        }
    }

    private class ExampleTreeCellRenderer
    extends CellRenderer {
        public ExampleTreeCellRenderer(AbstractTreeModel treeModel) {
            super(new RendererPreferences(treeModel));
        }

        public ExampleTreeCellRenderer(RendererPreferences preferences) {
            super(preferences);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ExampleEntry) {
                String text;
                String path = ((ExampleEntry)value).getExampleName();
                File installedExample = new File(ExtractExamplesDialog.this.examplesInstallationFolder, path);
                ProjectFile project = new ProjectFile(installedExample);
                String example = StringTools.replaceHtmlEntities((String)value.toString());
                if (project.exists()) {
                    String version = project.getVersion();
                    text = "<html><font color=\"#000000\">" + example + "</font>" + (version == null || version.length() == 0 ? "" : "<font color=\"#880000\"> (version installed &lt;" + version + "&gt;)</font></html>");
                } else {
                    text = "<html><font color=\"#000000\">" + example + "</font>";
                }
                this.setText(text);
            }
            return component;
        }
    }

    private class ExampleFolder
    implements TreeObject,
    Comparable<ExampleFolder> {
        private static final int EXAMPLE_FOLDER = 111;
        private ArrayList<ExampleFolder> containers = new ArrayList();
        private ArrayList<ExampleEntry> examples = new ArrayList();
        private File container;

        private ExampleFolder(File container) {
            this.container = container;
        }

        public String getPath() {
            return this.container.getPath();
        }

        public Object getChild(int index) {
            TreeObject result = index < this.containers.size() ? this.containers.get(index) : this.examples.get(index - this.containers.size());
            return result;
        }

        public int getChildCount() {
            return this.containers.size() + this.examples.size();
        }

        public int getIndexOfChild(Object child) {
            return 0;
        }

        public boolean isLeaf() {
            return this.containers.size() + this.examples.size() == 0;
        }

        public int getType() {
            return 111;
        }

        public void addContainer(ExampleFolder container) {
            this.containers.add(container);
        }

        public void addExample(ExampleEntry example) {
            this.examples.add(example);
        }

        public void sort() {
            Collections.sort(this.examples);
            Collections.sort(this.containers);
            for (ExampleFolder container : this.containers) {
                container.sort();
            }
        }

        public String toString() {
            return this.container.getName();
        }

        @Override
        public int compareTo(ExampleFolder o) {
            return this.container.compareTo(o.container);
        }
    }

    private class TreeModel
    extends AbstractTreeModel {
        private ExampleFolder root;

        private TreeModel() {
            super(new Properties("ch.e2e.builder.base.properties.tree"));
            File installationFolder = new File(System.getProperty("ch.e2e.builder.home"));
            File rootFolder = new File(installationFolder, "documentation/examples.zip");
            this.root = new ExampleFolder(new File(""));
            try {
                JarFile examples = new JarFile(rootFolder);
                HashMap<String, ExampleFolder> containers = new HashMap<String, ExampleFolder>();
                Enumeration<JarEntry> entries = examples.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(".zip")) continue;
                    ExampleEntry e = new ExampleEntry(entry, examples);
                    this.addToContainer(e, containers);
                }
                this.root.sort();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void addToContainer(ExampleEntry example, HashMap<String, ExampleFolder> containers) {
            File parent = example.getParentFile();
            if (parent == null) {
                this.root.addExample(example);
            } else {
                ExampleFolder container = containers.get(parent.getPath());
                if (container == null) {
                    container = new ExampleFolder(parent);
                    containers.put(container.getPath(), container);
                    parent = parent.getParentFile();
                    if (parent == null) {
                        this.root.addContainer(container);
                    } else {
                        ExampleFolder parentContainer = container;
                        while (parent != null) {
                            ExampleFolder nextParentContainer = containers.get(parent.getPath());
                            if (nextParentContainer == null) {
                                nextParentContainer = new ExampleFolder(parent);
                            }
                            nextParentContainer.addContainer(parentContainer);
                            parentContainer = nextParentContainer;
                            if ((parent = parent.getParentFile()) != null) continue;
                            this.root.addContainer(parentContainer);
                        }
                    }
                }
                container.addExample(example);
            }
        }

        public Object getRoot() {
            return this.root;
        }

        public void setRoot(ExampleFolder root) {
            this.root = root;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public String getTypeString(int type) {
            String result;
            switch (type) {
                case 111: {
                    result = "example.folder";
                    break;
                }
                case 222: {
                    result = "example.project";
                    break;
                }
                default: {
                    result = "treenode.unknown";
                }
            }
            return result;
        }

        public String toString(Object value) {
            String result = super.toString(value);
            return result;
        }
    }
}

