/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.TransactionParticipant;
import ch.e2e.builder.base.application.abstracts.TransactionHandler;
import ch.e2e.transaction.TransactionEvent;
import ch.e2e.transaction.TransactionException;
import ch.e2e.transaction.TransactionListener;
import ch.e2e.transaction.TransactionService;
import java.util.ArrayList;

public class E2EBuilderTransactionHandler
extends TransactionHandler
implements TransactionListener {
    public static final String ID = "ch.e2e.builder.base.application.E2EBuilderTransactionHandler";
    private ArrayList<TransactionParticipant> participants = new ArrayList();
    private int transactionCounter = 0;
    private E2EBuilderTransaction transaction;

    @Override
    public void doTransaction(E2EBuilderTransaction transaction, Object transactionData) {
        ++this.transactionCounter;
        if (transaction.useThread() && this.transactionCounter == 1) {
            this.transaction = transaction;
            TransactionService.execute((Object)transactionData, (ch.e2e.transaction.TransactionHandler)transaction, (TransactionListener)this);
        } else {
            TransactionEvent event = new TransactionEvent((Object)this);
            TransactionService.getTransactionListener().transactionStart(event);
            transaction.transactionStart(event);
            try {
                Object result = transaction.doTransaction(transactionData);
                event = new TransactionEvent((Object)this, result);
                transaction.transactionEnd(event);
                TransactionService.getTransactionListener().transactionEnd(event);
            }
            catch (Throwable throwable) {
                TransactionException exception = new TransactionException(throwable, (ch.e2e.transaction.TransactionHandler)transaction);
                transaction.transactionFailed(exception);
                TransactionService.getTransactionListener().transactionFailed(exception);
            }
            --this.transactionCounter;
        }
    }

    @Override
    public void addTransactionParticipant(TransactionParticipant participant) {
        this.participants.add(participant);
    }

    @Override
    public void removeTransactionParticipant(TransactionParticipant participant) {
        this.participants.remove(participant);
    }

    public void transactionStart(TransactionEvent event) {
        if (this.transaction != null) {
            this.transaction.transactionStart(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnd(TransactionEvent event) {
        if (this.transaction != null) {
            this.transaction.transactionEnd(event);
        }
        TransactionParticipant[] participants = new TransactionParticipant[this.participants.size()];
        TransactionParticipant[] transactionParticipantArray = "ch.e2e.builder.base.application.E2EBuilderTransactionHandler";
        synchronized ("ch.e2e.builder.base.application.E2EBuilderTransactionHandler") {
            this.participants.toArray(participants);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (TransactionParticipant participant : participants) {
                if (participant.isRemoveAfterAction()) {
                    this.removeTransactionParticipant(participant);
                }
                participant.transactionFinished();
            }
            --this.transactionCounter;
            return;
        }
    }

    public void transactionFailed(TransactionException exception) {
        if (this.transaction != null) {
            this.transaction.transactionFailed(exception);
        }
        --this.transactionCounter;
    }
}

