/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.awt.MessageBox;
import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.application.E2EBuilderLogfile;
import ch.e2e.builder.base.application.E2EBuilderMenuObserver;
import ch.e2e.builder.base.application.E2EBuilderStatusHandler;
import ch.e2e.builder.base.application.E2EBuilderTransactionHandler;
import ch.e2e.builder.base.application.Logging;
import ch.e2e.builder.base.application.ParentApplication;
import ch.e2e.builder.base.application.abstracts.MenuObserver;
import ch.e2e.builder.base.application.abstracts.ShowStatusEvent;
import ch.e2e.builder.base.application.abstracts.StatusHandler;
import ch.e2e.builder.base.application.abstracts.TransactionHandler;
import ch.e2e.builder.base.gui.E2EBuilderFrame;
import ch.e2e.builder.base.gui.SplashScreen;
import ch.e2e.builder.base.gui.menu.E2EBuilderMenuBar;
import ch.e2e.builder.base.licensing.CheckLicenseEvent;
import ch.e2e.builder.base.module.E2EBuilderInfo;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.ModuleFactory;
import ch.e2e.builder.base.module.XSLTToolsInfo;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.OutputDestination;
import ch.e2e.io.SystemErrRedirector;
import ch.e2e.io.SystemOutRedirector;
import ch.e2e.resource.Properties;
import ch.e2e.transaction.TransactionEvent;
import ch.e2e.transaction.TransactionException;
import ch.e2e.transaction.TransactionListener;
import ch.e2e.transaction.TransactionService;
import ch.e2e.util.ArgumentParser;
import ch.e2e.util.VersionChecker;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;

public class E2EBuilderStandalone
implements ParentApplication,
TransactionListener,
Logging {
    public static final String E2EBUILDER_STANDALONE_PACKAGE = "ch.e2e.builder.base.application";
    public static final String E2EBUILDER_STANDALONE_PACKAGE_PREFIX = "";
    private E2EBuilderFrame applicationFrame;
    private File[] moduleJarfiles;
    private File[] manifestFiles;
    private File[] testManifestFiles;
    private File infoManifestFile;
    private File builderManifestFile;
    private E2EBuilderMenuObserver menuObserver;
    private ModuleFactory moduleFactory;
    private E2EBuilderInfo builderInfo;
    private E2EBuilderInfo applicationInfo;
    private File xsltJarfile;
    private File infoJarfile;
    private SplashScreen splashScreen;
    private File[] testJarfiles;

    public E2EBuilderStandalone(ArgumentParser args) {
        int i;
        int length;
        ArrayList values;
        this.findJarfiles();
        if (args.isSet("manifest")) {
            values = args.getArgumentValues("manifest");
            this.manifestFiles = new File[values.size()];
            length = values.size();
            for (i = 0; i < length; ++i) {
                this.manifestFiles[i] = new File((String)values.get(i));
            }
        }
        if (args.isSet("test-manifest")) {
            values = args.getArgumentValues("test-manifest");
            this.testManifestFiles = new File[values.size()];
            length = values.size();
            for (i = 0; i < length; ++i) {
                this.testManifestFiles[i] = new File((String)values.get(i));
            }
        }
        if (args.isSet("info-manifest")) {
            values = args.getArgumentValues("info-manifest");
            this.infoManifestFile = new File((String)values.get(0));
        }
        if (args.isSet("builder-manifest")) {
            values = args.getArgumentValues("builder-manifest");
            this.builderManifestFile = new File((String)values.get(0));
        }
        this.menuObserver = new E2EBuilderMenuObserver();
    }

    @Override
    public String getPrefix() {
        return E2EBUILDER_STANDALONE_PACKAGE_PREFIX;
    }

    @Override
    public String getName() {
        return this.applicationInfo.getTitle();
    }

    @Override
    public String getDisplayName() {
        return this.applicationInfo.getShorttitle();
    }

    @Override
    public String getVersion() {
        return this.applicationInfo.getVersion();
    }

    @Override
    public String getBuildDate() {
        return this.applicationInfo.getDate();
    }

    @Override
    public Frame getApplicationFrame() {
        return this.applicationFrame;
    }

    @Override
    public String getPackage() {
        return E2EBUILDER_STANDALONE_PACKAGE;
    }

    @Override
    public String getModulePackagePrefix() {
        return E2EBUILDER_STANDALONE_PACKAGE_PREFIX;
    }

    @Override
    public File[] getManifestFiles() {
        return this.manifestFiles;
    }

    @Override
    public File[] getTestManifestFiles() {
        return this.testManifestFiles;
    }

    @Override
    public File[] getModuleJarfiles() {
        return this.moduleJarfiles;
    }

    @Override
    public File[] getTestJarfiles() {
        return this.testJarfiles;
    }

    @Override
    public XSLTToolsInfo getXSLTToolsInfo() {
        XSLTToolsInfo result = null;
        try {
            JarFile jarfile = new JarFile(this.xsltJarfile);
            Manifest infoManifest = jarfile.getManifest();
            result = new XSLTToolsInfo(infoManifest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void start(ProjectPool projectPool) {
        try {
            E2EBuilderMenuBar menuBar = new E2EBuilderMenuBar("e2ebuilder.standalone.menubar", projectPool);
            this.menuObserver.setMenuBar(menuBar);
            this.splashScreen = new SplashScreen(this.getApplicationInfo());
            this.splashScreen.setVisible(true);
            this.splashScreen.toFront();
            this.applicationFrame = new E2EBuilderFrame(menuBar, this.getApplicationInfo());
            TransactionService.execute(null, (ch.e2e.transaction.TransactionHandler)new LoadModulesTransaction(), (TransactionListener)this);
        }
        catch (Throwable t) {
            logger.severe("Caught a " + t.getClass().getName() + ".");
            logger.throwing(this.getClass().getName(), "start", t);
        }
    }

    public void transactionStart(TransactionEvent event) {
        boolean dummy = false;
    }

    public void transactionEnd(TransactionEvent event) {
        EventController.fire((EventObject)new ShowStatusEvent(this, null, E2EBUILDER_STANDALONE_PACKAGE_PREFIX, "status_messages"));
        this.applicationFrame.setVisible(true);
        this.applicationFrame.toFront();
        this.splashScreen.close();
        EventController.fire((EventObject)new CheckLicenseEvent(this));
        E2EBuilder.getInstance().getProjectPool().addProjectListener(this.applicationFrame);
        E2EBuilder.getInstance().getProjectPool().setInitialProject();
    }

    public void transactionFailed(TransactionException exception) {
        String classname = this.getClass().getName();
        E2EBuilder.logger.severe("Doing errorhandling of " + classname + ". Cause: " + exception.getTargetException().getClass().getName());
        E2EBuilder.logger.throwing(classname, "transactionFailed", exception.getTargetException());
        SwingUtilities.updateComponentTreeUI((Component)((Object)this.applicationFrame));
    }

    @Override
    public String getBuilderSystemLibraryPath() {
        String result = null;
        Properties applicationProperties = new Properties("ch.e2e.builder.base.properties.application", this.getClass().getClassLoader());
        String classpath = System.getProperty("java.class.path");
        String applicationJarfile = applicationProperties.getString("builder.jarfile", "builder.jar");
        int index = classpath.indexOf(applicationJarfile);
        String path = "lib" + File.separator + "system" + File.separator + "builder.jar";
        if (index != -1) {
            path = classpath.substring(classpath.lastIndexOf(File.pathSeparator, index) + 1, classpath.indexOf(File.pathSeparator, index));
        }
        if (path != null) {
            result = FileUtilities.getAbsolutePath((File)new File(path).getParentFile());
        }
        return result;
    }

    @Override
    public E2EBuilderInfo getBaseInfo() {
        if (this.builderInfo == null) {
            this.readInfoFiles();
        }
        return this.builderInfo;
    }

    @Override
    public E2EBuilderInfo getApplicationInfo() {
        if (this.builderInfo == null) {
            this.readInfoFiles();
        }
        return this.applicationInfo;
    }

    private void readInfoFiles() {
        Properties applicationProperties = new Properties("ch.e2e.builder.base.properties.application", this.getClass().getClassLoader());
        String classpath = System.getProperty("java.class.path");
        String applicationJarfile = applicationProperties.getString("builder.jarfile", "builder.jar");
        int index = classpath.indexOf(applicationJarfile);
        String path = classpath.substring(classpath.lastIndexOf(File.pathSeparator, index) + 1, classpath.indexOf(File.pathSeparator, index));
        if (this.builderManifestFile == null) {
            try {
                this.builderInfo = new E2EBuilderInfo(new File(path));
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), E2EBUILDER_STANDALONE_PACKAGE_PREFIX, e);
            }
        } else {
            try {
                this.builderInfo = new E2EBuilderInfo(new Manifest(new FileInputStream(this.builderManifestFile)));
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), E2EBUILDER_STANDALONE_PACKAGE_PREFIX, e);
            }
        }
        if (this.infoJarfile == null) {
            try {
                this.applicationInfo = new E2EBuilderInfo(new Manifest(new FileInputStream(this.infoManifestFile)));
            }
            catch (Exception e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), E2EBUILDER_STANDALONE_PACKAGE_PREFIX, e);
            }
        } else {
            try {
                this.applicationInfo = new E2EBuilderInfo(this.infoJarfile);
            }
            catch (Exception ex) {
                try {
                    this.applicationInfo = new E2EBuilderInfo(new File(path));
                }
                catch (IOException e) {
                    logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    logger.throwing(this.getClass().getName(), E2EBUILDER_STANDALONE_PACKAGE_PREFIX, e);
                }
            }
        }
    }

    @Override
    public MenuObserver getMenuObserver() {
        return this.menuObserver;
    }

    @Override
    public StatusHandler getStatusHandler() {
        return new E2EBuilderStatusHandler();
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new E2EBuilderTransactionHandler();
    }

    private static void checkSystem() {
        for (Object o : System.getProperties().keySet()) {
            System.out.println(o + "=" + System.getProperty(o.toString()));
        }
        String version = System.getProperty("java.version");
        if (!VersionChecker.checkVersion((String)"1.4.1")) {
            MessageBox mb = new MessageBox("You are using the java version " + version + ".\n To run E2EBuilder you need Java version 1.4.1 or higher.", "Fatal Error");
            mb.centerOnScreen();
            mb.setVisible(true);
            System.exit(0);
        }
    }

    private static void redirectOutErr() {
        E2EBuilderLogfile out = new E2EBuilderLogfile();
        SystemOutRedirector.getInstance().addOutputDestination((OutputDestination)out);
        SystemOutRedirector.getInstance().setEnabled(true);
        SystemOutRedirector.getInstance().setOriginalStreamEnabled(true);
        SystemErrRedirector.getInstance().addOutputDestination((OutputDestination)out);
        SystemErrRedirector.getInstance().setEnabled(true);
        SystemErrRedirector.getInstance().setOriginalStreamEnabled(true);
    }

    private static void setLookAndFeel() {
        try {
            LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        }
        catch (Exception ex) {
            E2EBuilder.logger.severe("Caught a " + ex.getClass().getName() + ".");
            E2EBuilder.logger.throwing(E2EBuilderStandalone.class.getName(), "setLookAndFeel", ex);
        }
    }

    private void findJarfiles() {
        String classpath = System.getProperty("java.class.path");
        ArrayList<File> moduleFiles = new ArrayList<File>();
        ArrayList<File> testFiles = new ArrayList<File>();
        String[] paths = classpath.split(File.pathSeparator);
        String modulesSearchPath = "lib" + File.separator + "modules";
        String testSearchPath = "lib" + File.separator + "test";
        String infoSearchPath = "lib" + File.separator + "system" + File.separator + "info.jar";
        for (String path : paths) {
            if (path.contains(modulesSearchPath)) {
                moduleFiles.add(new File(path));
                continue;
            }
            if (path.contains(testSearchPath)) {
                testFiles.add(new File(path));
                continue;
            }
            if (path.endsWith("compilerTools.jar")) {
                this.xsltJarfile = new File(path);
                continue;
            }
            if (!path.endsWith(infoSearchPath)) continue;
            this.infoJarfile = new File(path);
        }
        this.testJarfiles = new File[testFiles.size()];
        testFiles.toArray(this.testJarfiles);
        this.moduleJarfiles = new File[moduleFiles.size()];
        moduleFiles.toArray(this.moduleJarfiles);
        if (System.getProperty("ch.e2e.builder.application.home") == null) {
            String applicationHome = new File(".").getAbsolutePath();
            if (this.infoJarfile != null) {
                applicationHome = this.infoJarfile.getParentFile().getAbsolutePath();
                applicationHome = applicationHome.substring(0, applicationHome.length() - "/lib/system".length());
            }
            System.out.println("applicationHome = " + applicationHome);
            System.setProperty("ch.e2e.builder.application.home", applicationHome);
            System.setProperty("install.root", applicationHome);
            System.setProperty("ch.e2e.builder.home", applicationHome);
        }
    }

    @Override
    public ModuleFactory getModuleFactory() {
        return this.moduleFactory;
    }

    @Override
    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    static {
        E2EBuilderStandalone.redirectOutErr();
        System.out.println("Starting E2EBuilder Analyzer " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(new Date()));
        E2EBuilderStandalone.checkSystem();
        E2EBuilderStandalone.setLookAndFeel();
        Locale.setDefault(Locale.ENGLISH);
        System.setProperty("e2e.builder.license.file", "license.xml");
    }

    private class LoadModulesTransaction
    implements ch.e2e.transaction.TransactionHandler {
        private LoadModulesTransaction() {
        }

        public Object doTransaction(Object transactionData) {
            E2EBuilderFrame frame = E2EBuilderStandalone.this.applicationFrame;
            frame.setModuleFactory(E2EBuilderStandalone.this.moduleFactory);
            E2EBuilderStandalone.this.menuObserver.setToolBar(frame.getToolbar());
            for (E2EBuilderModule module : E2EBuilderStandalone.this.moduleFactory.getModules()) {
                module.finalizeInitialization();
            }
            return null;
        }
    }
}

