/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.eal;

import ch.e2e.builder.eal.EALParser;
import ch.e2e.builder.eal.SimpleNode;
import ch.e2e.builder.eal.Token;

public class EALNode
extends SimpleNode {
    protected Token token;
    protected String image;
    protected String unescapedImage;
    protected String type;
    protected int startLine;
    protected int endLine;
    protected int start;
    protected int end;
    private boolean lazy = false;
    private int selectedPart = -1;

    public EALNode(int i) {
        super(i);
    }

    public EALNode(EALParser p, int i) {
        super(p, i);
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token t) {
        this.token = t;
        this.setImage(t.image);
    }

    public String getImage() {
        return this.image;
    }

    public String getUnescapedImage() {
        return this.unescapedImage;
    }

    public void setImage(String image) {
        this.image = image;
        this.unescapedImage = EALNode.unescape(image);
    }

    public String getValue() {
        return null;
    }

    public void setValue(String image) {
        this.setImage(image);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isArrayElement() {
        return "ArrayElement".equals(this.type);
    }

    public boolean isCall() {
        return "Call".equals(this.type);
    }

    public String getSelectedImagePart() {
        return this.selectedPart == -1 ? null : ((EALNode)this.jjtGetChild(this.selectedPart)).getImage();
    }

    public String getFinalImagePart() {
        EALNode lastNode = this.getLastChild();
        return lastNode == null ? null : lastNode.getImage();
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void isLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public SimpleNode getSelectedChild() {
        return this.selectedPart == -1 ? null : (EALNode)this.jjtGetChild(this.selectedPart);
    }

    public int getSelectedPart() {
        return this.selectedPart == -1 ? this.jjtGetNumChildren() - 1 : this.selectedPart;
    }

    public void setSelectedPart(int i) {
        this.selectedPart = i;
    }

    public EALNode getFirstChild() {
        return this.jjtGetNumChildren() == 0 ? null : (EALNode)this.jjtGetChild(0);
    }

    public EALNode getLastChild() {
        int n = this.jjtGetNumChildren();
        return n == 0 ? null : (EALNode)this.jjtGetChild(n - 1);
    }

    public static String unescape(String s) {
        String result = "";
        int length = s.length();
        if (length > 0) {
            if (s.charAt(0) == '`') {
                if (length > 1) {
                    result = s.substring(1, s.charAt(length - 1) == '`' ? length - 1 : length);
                }
            } else {
                result = s;
            }
        }
        return result;
    }
}

