/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.dom.DomUtilities;
import ch.e2e.test.options.OptionChangeEvent;
import ch.e2e.test.options.OptionChangeEventMulticaster;
import ch.e2e.test.options.OptionChangeListener;
import ch.e2e.test.options.OptionGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public abstract class Option<T> {
    private int index = -1;
    protected T value;
    private T defaultValue;
    private String name;
    private String key;
    private boolean required;
    private ArrayList<String> dependencies;
    private String dependencyString;
    private boolean inherited = false;
    private boolean visible = true;
    private OptionGroup group = null;
    private OptionChangeListener optionChangeListener;

    protected Option(String name, int index) {
        this(name, null, null, index);
    }

    protected Option(String name, String key, int index) {
        this(name, key, null, index);
    }

    protected Option(String name, T defaultValue, int index) {
        this(name, null, defaultValue, index);
    }

    protected Option(String name, String key, T defaultValue, int index) {
        this.name = name;
        this.key = key;
        this.index = index;
        this.defaultValue = defaultValue;
        this.required = false;
        this.dependencies = new ArrayList();
    }

    public abstract T createValue(String var1);

    public abstract Option<T> createCopyInstance();

    public abstract T createCopyOfValue();

    public void addOptionChangeListener(OptionChangeListener listener) {
        this.optionChangeListener = OptionChangeEventMulticaster.addListener(this.optionChangeListener, listener);
    }

    public void removeOptionChangeListener(OptionChangeListener listener) {
        this.optionChangeListener = OptionChangeEventMulticaster.removeListener(this.optionChangeListener, listener);
    }

    public boolean containsOptions() {
        return false;
    }

    public List<Option> getOptions() {
        return Collections.emptyList();
    }

    public void initialize(Element element) {
        String value = element.hasAttribute("value") ? element.getAttribute("value") : DomUtilities.getTextValue((Element)element, null);
        this.setValueWithoutNotification(this.createValue(value));
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        T oldValue = this.value;
        this.value = value;
        if (this.optionChangeListener != null && (oldValue != null && value != null && !oldValue.equals(value) || oldValue == null && value != null || oldValue != null && value == null)) {
            this.optionChangeListener.optionChanged(new OptionChangeEvent<T>(this, value, oldValue));
        }
    }

    public void setValueWithoutNotification(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key == null ? this.name : this.key;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void addDependency(String dependency) {
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean hasDependency(String option) {
        return this.dependencies.contains(option);
    }

    public String getDependencyString() {
        return this.dependencyString == null ? (this.value == null ? (this.getDefaultValue() == null ? null : this.getDefaultValue().toString()) : this.value.toString()) : this.dependencyString;
    }

    public void setDependencyString(String dependencyString) {
        this.dependencyString = dependencyString;
    }

    public OptionGroup getGroup() {
        return this.group;
    }

    public void setGroup(OptionGroup group) {
        this.group = group;
    }

    public void clearDependencies() {
        this.dependencies.clear();
        this.dependencyString = null;
    }

    public Option<T> createCopy() {
        Option<T> result = this.createCopyInstance();
        result.setDefaultValue(this.getDefaultValue());
        result.setValue(this.createCopyOfValue());
        result.setInherited(this.isInherited());
        for (String dependency : this.dependencies) {
            result.addDependency(dependency);
        }
        result.setDependencyString(this.getDependencyString());
        result.key = this.key;
        return result;
    }

    public void merge(Option<T> copy) {
        if (this.getValue() == null && copy.getValue() != null) {
            this.setValue(copy.getValue());
            this.setInherited(copy.isInherited());
        }
    }

    public void toXml(Element parent) {
        this.toXml("option", parent);
    }

    public void toXml(String elementName, Element parent) {
        if (this.value != null) {
            Element option = this.createXmlElement(elementName, parent);
            parent.appendChild(option);
        }
    }

    protected Element createXmlElement(String elementName, Element parent) {
        Element option = parent.getOwnerDocument().createElement(elementName);
        option.setAttribute("name", this.getKey());
        if (this.value instanceof File) {
            option.setAttribute("value", ((File)this.value).getPath().replace("\\", "/"));
        } else {
            String value = this.value.toString();
            if (this.isSimpleString(value)) {
                option.setAttribute("value", value);
            } else {
                option.appendChild(parent.getOwnerDocument().createTextNode(value));
            }
        }
        return option;
    }

    protected boolean isSimpleString(String value) {
        return value.indexOf(10) == -1 && value.indexOf(13) == -1 && value.indexOf(9) == -1;
    }

    public String toString() {
        return "Option{value=" + this.value + ", name='" + this.name + '\'' + ", key='" + this.key + '\'' + '}';
    }
}

