/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.test.Utilities;
import ch.e2e.test.options.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;

public class FileOption
extends Option<File> {
    private HashMap<String, FileExtension> fileExtensions = new HashMap();
    private boolean directory;
    private boolean allFilesSelectionAllowed = false;
    private File defaultStartFolder;

    public FileOption(String name, int index) {
        super(name, index);
    }

    public FileOption(String name, String key, int index) {
        super(name, key, index);
    }

    public FileOption(String name, File defaultValue, int index) {
        super(name, defaultValue, index);
    }

    public FileOption(String name, String key, File defaultValue, int index) {
        super(name, key, defaultValue, index);
    }

    @Override
    public File createValue(String valueString) {
        return (File)Utilities.createValue(valueString, File.class);
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isAllFilesSelectionAllowed() {
        return this.allFilesSelectionAllowed;
    }

    public void setAllFilesSelectionAllowed(boolean allFilesSelectionAllowed) {
        this.allFilesSelectionAllowed = allFilesSelectionAllowed;
    }

    public void addFileExtension(String extension, String description) {
        FileExtension fileExtension = this.fileExtensions.get(description);
        if (fileExtension == null) {
            fileExtension = new FileExtension(description);
            this.fileExtensions.put(description, fileExtension);
        }
        fileExtension.addExtension(extension);
    }

    public HashMap<String, FileExtension> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(HashMap<String, FileExtension> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public File getDefaultStartFolder() {
        return this.defaultStartFolder;
    }

    public void setDefaultStartFolder(File defaultStartFolder) {
        this.defaultStartFolder = defaultStartFolder;
    }

    @Override
    protected Element createXmlElement(String elementName, Element parent) {
        Element result = super.createXmlElement(elementName, parent);
        result.setAttribute("directory", String.valueOf(this.directory));
        return result;
    }

    @Override
    public Option<File> createCopyInstance() {
        FileOption result = new FileOption(this.getName(), this.getIndex());
        result.fileExtensions = new HashMap<String, FileExtension>(this.fileExtensions);
        result.directory = this.directory;
        return result;
    }

    @Override
    public File createCopyOfValue() {
        return this.getValue() == null ? null : new File(((File)this.getValue()).getAbsolutePath());
    }

    public static class FileExtension {
        private ArrayList<String> extensions = new ArrayList();
        private String description;

        public FileExtension(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void addExtension(String extension) {
            this.extensions.add(extension);
        }

        public String[] getExtensions() {
            String[] extensions = new String[this.extensions.size()];
            return this.extensions.toArray(extensions);
        }
    }
}

