/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.test.E2ETask;
import ch.e2e.test.E2ETest;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestCreateAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;

public class TestType<T extends OptionContainer>
implements Comparable<TestType> {
    private boolean optionsEditable;
    private Icon icon;
    private Class type;
    private boolean create;
    private String name;
    private String displayName;
    private TestCreateAction createAction;

    protected TestType(String name, Class type, boolean create, boolean optionsEditable, Icon icon) {
        this.name = name;
        this.optionsEditable = optionsEditable;
        this.icon = icon;
        this.type = type;
        this.create = create;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isOptionsEditable() {
        return this.optionsEditable;
    }

    public boolean isTest() {
        return E2ETest.class.isAssignableFrom(this.type);
    }

    public boolean isTask() {
        return E2ETask.class.isAssignableFrom(this.type);
    }

    public boolean isResultCompare() {
        return ResultCompare.class.isAssignableFrom(this.type);
    }

    public T newInstance() throws IllegalAccessException, InstantiationException {
        OptionContainer instance = (OptionContainer)this.type.newInstance();
        instance.setType(this);
        return (T)instance;
    }

    public Object newInstance(String s) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor typeConstructor = this.type.getConstructor(String.class);
        return typeConstructor.newInstance(s);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(TestType type) {
        return this.name.compareToIgnoreCase(type.name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean hasCreateAction() {
        return this.getCreateAction() != null;
    }

    public TestCreateAction getCreateAction() {
        return this.createAction;
    }

    public void setCreateAction(TestCreateAction createAction) {
        this.createAction = createAction;
    }

    public String toString() {
        return this.displayName == null ? this.name : this.displayName;
    }
}

