/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.E2ETask;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.LogfileHeader;
import ch.e2e.test.PropertiesHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestLogfile
implements TestListener {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("MMM dd yyyy, HH:mm:ss");
    private File logfile;
    private boolean delete;
    private LogfileHeader header;
    private static HashMap<String, String> replaceMap = new HashMap();

    public TestLogfile() {
    }

    public TestLogfile(Element logfileElement, File parentFile) {
        String filename = PropertiesHelper.getAttribute(logfileElement, "name", replaceMap).replace('\\', '/');
        this.logfile = E2ETestSuite.createTestsuiteFile(filename, parentFile);
        boolean bl = this.delete = !DomUtilities.getBoolean((Element)logfileElement, (String)"append", (boolean)false);
        if (!this.logfile.getParentFile().exists()) {
            this.logfile.getParentFile().mkdirs();
        }
        this.readHeader(logfileElement);
    }

    public TestLogfile(File logfile, boolean delete) {
        this.logfile = logfile;
        this.delete = delete;
        if (!logfile.getParentFile().exists()) {
            logfile.getParentFile().mkdirs();
        }
    }

    public long lastModified() {
        return this.logfile.lastModified();
    }

    public boolean exists() {
        return this.logfile.exists();
    }

    public File getLogfile() {
        return this.logfile;
    }

    public void delete() {
        if (this.delete && this.logfile.exists()) {
            this.logfile.delete();
        }
    }

    public void addError(Test test, Throwable throwable) {
        this.printMessage(throwable.getMessage());
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.printMessage(test + ": " + assertionFailedError.getMessage());
    }

    public void endTest(Test test) {
        String prefix = test instanceof E2ETask ? "Task " : "Test ";
        this.printMessage(prefix + test + "' finished at " + dateFormatter.format(new Date()) + '.');
    }

    public void startTest(Test test) {
        String prefix = test instanceof E2ETask ? "Task " : "Test ";
        this.printMessage(prefix + test + "' started at " + dateFormatter.format(new Date()) + '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMessage(String message) {
        PrintWriter logWriter = null;
        try {
            boolean writeHeader = this.header != null && !this.logfile.exists();
            logWriter = new PrintWriter((Writer)new FileWriter(this.logfile, true), true);
            if (writeHeader) {
                logWriter.println(this.header.toString());
            }
            logWriter.println(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (logWriter != null) {
                logWriter.flush();
                logWriter.close();
            }
        }
    }

    public LogfileHeader createHeader() {
        if (this.header != null) {
            throw new BuildException("Only one header element allowed");
        }
        this.header = new LogfileHeader();
        return this.header;
    }

    public void setName(File file) {
        this.logfile = file;
        if (!this.logfile.getParentFile().exists()) {
            this.logfile.getParentFile().mkdirs();
        }
    }

    private void readHeader(Element logfileElement) {
        NodeList headers = logfileElement.getElementsByTagName("Header");
        if (headers != null && headers.getLength() == 1) {
            this.header = new LogfileHeader((Element)headers.item(0), replaceMap);
        }
    }

    public TestLogfile clone(Properties properties) {
        TestLogfile result = new TestLogfile();
        result.logfile = this.logfile;
        result.delete = this.delete;
        if (this.header != null) {
            result.header = this.header.clone(properties);
        }
        return result;
    }

    public Element toXML(Document ownerDocument) {
        Element result = ownerDocument.createElement("Logfile");
        result.setAttribute("name", this.logfile.getAbsolutePath());
        if (this.header != null) {
            result.appendChild(this.header.toXML(ownerDocument));
        }
        return result;
    }

    public String toString() {
        return this.logfile.getName();
    }

    static {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        replaceMap.put("date", dateFormat.format(date));
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH_mm");
        replaceMap.put("time", timeFormat.format(date));
        replaceMap.put("temp", System.getProperty("java.io.tmpdir"));
        replaceMap.put("tmp", System.getProperty("java.io.tmpdir"));
    }
}

