/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.io.FileUtilities;
import ch.e2e.test.AbstractResultCompare;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.TestResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FileCompare
extends AbstractResultCompare {
    private static final int TEXT = 0;
    private static final int BINARY = 1;
    private int type;
    private CompareFile testResult;
    private CompareFile controlResult;

    @Override
    public void doTest(E2ETest e2eTest) throws Exception {
        File controlFile = this.controlResult.getFile();
        File testFile = this.testResult.getFile();
        Assert.assertTrue((String)("Control file " + controlFile.getName() + " does not exists."), (boolean)controlFile.exists());
        Assert.assertTrue((String)("Test file " + testFile.getName() + " does not exists."), (boolean)testFile.exists());
        Assert.assertTrue((String)"Control file not readable", (boolean)controlFile.canRead());
        Assert.assertTrue((String)"Test file not readable", (boolean)testFile.canRead());
        switch (this.type) {
            case 1: {
                this.assertBinaryEquals(controlFile, testFile);
                break;
            }
            case 0: {
                this.assertTextEquals(controlFile, testFile);
            }
        }
    }

    @Override
    public void init(Element options) {
        super.init(options);
        this.checkOptions(options);
    }

    @Override
    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
        this.checkOptions(options);
    }

    @Override
    public TestResult getTestResult(boolean includeHiddenData, Map<String, String> properties) {
        String testData;
        String referenceData;
        if (this.type == 0) {
            StringWriter reference = new StringWriter();
            try {
                FileUtilities.copy((Reader)new FileReader(this.controlResult.getFile()), (Writer)reference);
            }
            catch (Exception exception) {
                // empty catch block
            }
            referenceData = reference.toString();
            StringWriter test = new StringWriter();
            try {
                FileUtilities.copy((Reader)new FileReader(this.testResult.getFile()), (Writer)test);
            }
            catch (Exception exception) {
                // empty catch block
            }
            testData = test.toString();
        } else {
            ByteArrayOutputStream reference = new ByteArrayOutputStream();
            try {
                FileUtilities.copy((InputStream)new FileInputStream(this.controlResult.getFile()), (OutputStream)reference);
            }
            catch (Exception test) {
                // empty catch block
            }
            referenceData = reference.toString();
            ByteArrayOutputStream test = new ByteArrayOutputStream();
            try {
                FileUtilities.copy((InputStream)new FileInputStream(this.testResult.getFile()), (OutputStream)test);
            }
            catch (Exception exception) {
                // empty catch block
            }
            testData = test.toString();
        }
        return new TestResult(referenceData, testData);
    }

    @Override
    public void toXml(Element parent) {
    }

    @Override
    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        return null;
    }

    @Override
    protected void createOptions() {
    }

    private void checkOptions(Element options) {
        NodeList testFiles;
        this.type = this.getType(options.getAttribute("compareType"));
        NodeList controlFiles = options.getElementsByTagName("control");
        if (controlFiles != null && controlFiles.getLength() == 1) {
            this.controlResult = new CompareFile((Element)controlFiles.item(0));
        }
        if ((testFiles = options.getElementsByTagName("test")) != null && testFiles.getLength() == 1) {
            this.testResult = new CompareFile((Element)testFiles.item(0));
        }
    }

    private int getType(String attribute) {
        int type = attribute.equalsIgnoreCase("binary") ? 1 : 0;
        return type;
    }

    private void assertTextEquals(File control, File test) {
        BufferedReader controlReader = null;
        BufferedReader testReader = null;
        try {
            controlReader = new BufferedReader(new FileReader(control));
            testReader = new BufferedReader(new FileReader(test));
            this.assertTextEquals(controlReader, testReader);
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.toString());
        }
        finally {
            try {
                if (controlReader != null) {
                    controlReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (testReader != null) {
                    testReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void assertTextEquals(BufferedReader controlReader, BufferedReader testReader) {
        try {
            int line = 1;
            String controlLine = controlReader.readLine();
            String testLine = testReader.readLine();
            while (controlLine != null && testLine != null) {
                Assert.assertEquals((String)("Line " + line + ": \"" + controlLine + "\" expected but was \"" + testLine + "\"."), (String)controlLine, (String)testLine);
                controlLine = controlReader.readLine();
                testLine = testReader.readLine();
                ++line;
            }
            if (controlLine != null) {
                Assert.fail((String)("Line " + line + ": \"" + controlLine + "\" expected but was <EOF>."));
            } else if (testLine != null) {
                Assert.fail((String)("Line " + line + ": <EOF> expected but was \" + testLine + \"."));
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.toString());
        }
    }

    private void assertBinaryEquals(File control, File test) {
        try {
            ByteArrayOutputStream controlOut = new ByteArrayOutputStream();
            ByteArrayOutputStream testOut = new ByteArrayOutputStream();
            FileUtilities.copy((InputStream)new FileInputStream(control), (OutputStream)controlOut);
            FileUtilities.copy((InputStream)new FileInputStream(test), (OutputStream)testOut);
            byte[] controlBytes = controlOut.toByteArray();
            byte[] testBytes = testOut.toByteArray();
            if (controlBytes.length < testBytes.length) {
                Assert.fail((String)"Control file is longer then the test file.");
            } else if (controlBytes.length < testBytes.length) {
                Assert.fail((String)"Control file is shorter then the test file.");
            } else {
                for (int i = 0; i < controlBytes.length; ++i) {
                    if (controlBytes[i] == testBytes[i]) continue;
                    Assert.fail((String)("Files differ at byte " + i + "."));
                }
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.toString());
        }
    }
}

