/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.PropertiesHelper;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.Testable;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class E2ETestcase
implements Testable {
    private StringOption name;
    private HashMap<String, String> properties = new HashMap();
    private E2ETestSuite parent;
    private E2ETest test;
    private boolean logfileSet;
    boolean inLibrary = false;
    private float duration;

    public E2ETestcase(Element testcase, File parent) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        this.addProperties(testcase);
        PropertiesHelper.replaceProperties(testcase, this.properties);
        this.name = new StringOption("Name", "key.option.test.name", -100);
        if (testcase.hasAttribute("name")) {
            this.name.setValue(testcase.getAttribute("name"));
        }
        this.createTest(testcase, parent);
    }

    public E2ETestcase(String name, E2ETest test, E2ETestSuite parent) {
        this.name = new StringOption("Name", "key.option.test.name", -100);
        this.name.setDefaultValue(name);
        test.setOwner(this);
        this.test = test;
        this.parent = parent;
        Option option = test.getOption("key.option.test.name");
        if (option.getValue() == null && option.getDefaultValue() == null) {
            test.setName(this.name);
        }
    }

    @Override
    public String getName() {
        return this.name.getValue() == null ? (String)this.name.getDefaultValue() : (String)this.name.getValue();
    }

    public void setName(String name) {
        this.name.setValue(name);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    public StringOption getNameOption() {
        return this.name;
    }

    public boolean hasIgnoredDifferences() {
        return this.test != null && this.test.getResult() != null && this.test.getResult().hasIgnoredDifferences();
    }

    public E2ETestResult getResult() {
        return this.test == null ? null : this.test.getResult();
    }

    public ArrayList<ErrorElement> getErrors() {
        return this.test == null ? new ArrayList() : this.test.getErrors();
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public HashMap<String, String> getPropertiesWithInherited() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.parent.getPropertiesWithInherited());
        result.putAll(this.properties);
        return result;
    }

    public String toString() {
        return this.name == null ? "" : this.getName();
    }

    @Override
    public E2ETestSuite getParent() {
        return this.parent;
    }

    @Override
    public void setParent(E2ETestSuite parent) {
        this.parent = parent;
    }

    public E2ETest getTest() {
        return this.test;
    }

    @Override
    public void clean() {
        this.test.cleanOut();
        this.properties.clear();
    }

    public int countTestCases() {
        return this.getTest().countTestCases();
    }

    public void run(TestResult result) {
        long start = System.currentTimeMillis();
        this.mergeInheritedOptions();
        Utilities.replaceProperties(this);
        HashMap<String, String> addedProperties = this.getPropertiesWithInherited();
        System.getProperties().putAll((Map<?, ?>)addedProperties);
        this.test.getErrors().clear();
        this.test.run(result);
        for (String key : addedProperties.keySet()) {
            System.getProperties().remove(key);
        }
        this.duration = (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    public float getDuration() {
        return this.duration;
    }

    @Override
    public void cancel() {
        this.test.cancel();
    }

    private void mergeInheritedOptions() {
        Utilities.mergeOptions(this.getParent().getInheritedOptions(this.test.getType(), true), this.getTest());
        if (this.test.getResult() != null) {
            for (ResultCompare compare : this.test.getResult().getResultCompares()) {
                OptionContainer inheritedOptions = this.getParent().getInheritedOptions(compare.getType(), true);
                Utilities.mergeOptions(inheritedOptions, compare);
            }
        }
    }

    @Override
    public void deleteLogfile() {
        this.test.deleteLogfile();
    }

    @Override
    public TestLogfile getLogfile() {
        return this.test.getLogfile();
    }

    @Override
    public void setLogfile(TestLogfile logfile) {
        this.test.setLogfile(logfile);
    }

    public boolean isLogfileSet() {
        return this.logfileSet;
    }

    public void setLogfileSet(boolean logfileSet) {
        this.logfileSet = logfileSet;
    }

    public Element toXml(Document ownerDocument) {
        Element testcaseElement = ownerDocument.createElement("testcase");
        testcaseElement.setAttribute("name", this.getName());
        testcaseElement.setAttribute("type", this.test.getType().getName());
        if (this.isLogfileSet()) {
            Element logfileElement = ownerDocument.createElement("logfile");
            logfileElement.setAttribute("name", this.test.getLogfile().getLogfile().getAbsolutePath());
            testcaseElement.appendChild(logfileElement);
        }
        if (this.test != null) {
            Element options = this.test.optionsToXml(false, ownerDocument);
            testcaseElement.appendChild(options);
            if (this.test.getResult() != null) {
                this.test.getResult().toXml(testcaseElement);
            }
        }
        return testcaseElement;
    }

    public void setTestFolder(File testFolder) {
        if (this.test != null) {
            this.test.setTestFolder(testFolder);
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        if (this.test != null) {
            this.test.setReferenceFolder(referenceFolder);
        }
    }

    public void setSourceFolder(File referenceFolder) {
        if (this.test != null) {
            this.test.setSourceFolder(referenceFolder);
        }
    }

    @Override
    public Testable clone() throws CloneNotSupportedException {
        return (E2ETestcase)super.clone();
    }

    @Override
    public boolean isInLibrary() {
        return this.inLibrary;
    }

    @Override
    public void setInLibrary(boolean inLibrary) {
        this.inLibrary = inLibrary;
    }

    private void createTest(Element testcase, File parent) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        String type = null;
        if (testcase.hasAttribute("test")) {
            type = testcase.getAttribute("test");
        } else if (testcase.hasAttribute("type")) {
            type = testcase.getAttribute("type");
        }
        this.test = Utilities.createTest(TypeFactory.getInstance().getType(type));
        this.test.setOwner(this);
        this.test.initialize(testcase);
        this.test.setLogfile(this.readLogfile(testcase, parent));
    }

    private void addProperties(Element testcase) {
        NodeList properties = testcase.getElementsByTagName("property");
        int length = properties.getLength();
        for (int i = 0; i < length; ++i) {
            Element property = (Element)properties.item(i);
            String name = PropertiesHelper.getAttribute(property, "name", this.properties);
            String value = PropertiesHelper.getAttribute(property, "value", this.properties);
            this.properties.put(name, value);
        }
    }

    private TestLogfile readLogfile(Element parent, File parentFile) {
        TestLogfile logfile = null;
        NodeList logfiles = parent.getElementsByTagName("logfile");
        if (logfiles != null && logfiles.getLength() == 1) {
            logfile = new TestLogfile((Element)logfiles.item(0), parentFile);
            this.logfileSet = true;
        } else {
            this.logfileSet = false;
        }
        return logfile;
    }

    @Override
    public boolean canWrite() {
        return this.parent.canWrite();
    }
}

