/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestResult;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.options.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E2ETestResult {
    private String name;
    private List<ResultCompare> resultCompares = new ArrayList<ResultCompare>();
    private String referenceData;
    private String testData;

    public E2ETestResult(Element result, Testable owner) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.name = result.getAttribute("name");
        this.addResultCompares(result, owner);
    }

    public E2ETestResult(String name) {
        this.name = name;
    }

    public E2ETestResult() {
        this.name = "";
    }

    public String getName() {
        return this.name;
    }

    public final void doTest(E2ETest test) throws Exception {
        this.referenceData = null;
        this.testData = null;
        for (ResultCompare resultCompare : this.resultCompares) {
            try {
                resultCompare.doTest(test);
            }
            catch (AssertionFailedError e) {
                test.getTestResult().addFailure((Test)test, e);
            }
            catch (Throwable e) {
                test.getTestResult().addError((Test)test, e);
            }
        }
    }

    public void test2Reference(Map<String, String> properties) throws IOException {
        for (ResultCompare resultCompare : this.resultCompares) {
            resultCompare.test2Reference(properties);
            this.referenceData = null;
        }
    }

    public void moveReferenceData(File oldReferenceFolder, File newReferenceFolder, Map<String, String> runProperties) {
        for (ResultCompare compare : this.resultCompares) {
            compare.moveReferenceData(oldReferenceFolder, newReferenceFolder, runProperties);
        }
    }

    public void clearReferenceAndTestData() {
        this.referenceData = null;
        this.testData = null;
    }

    public String getReferenceData(ErrorDetail erroDetail, boolean includeHiddenData, Map<String, String> properties) {
        String referenceData = null;
        int length = this.resultCompares.size();
        for (int i = 0; referenceData == null && i < length; ++i) {
            ResultCompare resultCompare = this.resultCompares.get(i);
            TestResult testResult = resultCompare.getTestResult(erroDetail, includeHiddenData, properties);
            if (testResult == null) continue;
            referenceData = testResult.getReferenceData();
        }
        return referenceData;
    }

    public String getReferenceData(boolean includeHiddenData, Map<String, String> properties) {
        if (this.referenceData == null) {
            StringBuilder reference = new StringBuilder();
            if (this.resultCompares.size() == 1) {
                reference.append(this.resultCompares.get(0).getTestResult(includeHiddenData, properties).getReferenceData());
            } else {
                for (ResultCompare resultCompare : this.resultCompares) {
                    reference.append(resultCompare.getName()).append("\n").append(resultCompare.getTestResult(includeHiddenData, properties).getReferenceData()).append("\n");
                }
            }
            this.referenceData = reference.toString();
        }
        return this.referenceData;
    }

    public String getTestData(ErrorDetail erroDetail, boolean includeHiddenData, Map<String, String> properties) {
        String testData = null;
        int length = this.resultCompares.size();
        for (int i = 0; testData == null && i < length; ++i) {
            ResultCompare resultCompare = this.resultCompares.get(i);
            TestResult testResult = resultCompare.getTestResult(erroDetail, includeHiddenData, properties);
            if (testResult == null) continue;
            testData = testResult.getTestData();
        }
        return testData;
    }

    public String getTestData(boolean includeHiddenData, Map<String, String> properties) {
        if (this.testData == null) {
            StringBuilder test = new StringBuilder();
            if (this.resultCompares.size() == 1) {
                test.append(this.resultCompares.get(0).getTestResult(includeHiddenData, properties).getTestData());
            } else {
                for (ResultCompare resultCompare : this.resultCompares) {
                    test.append(resultCompare.getName()).append("\n").append(resultCompare.getTestResult(includeHiddenData, properties).getTestData()).append("\n");
                }
            }
            this.testData = test.toString();
        }
        return this.testData;
    }

    public HashMap<String, Option> getOptions() {
        HashMap<String, Option> options;
        if (this.resultCompares.size() == 1) {
            options = this.resultCompares.get(0).getOptions();
        } else {
            options = new HashMap();
            for (ResultCompare compare : this.resultCompares) {
                options.putAll(compare.getOptions());
            }
        }
        return options;
    }

    public List<ResultCompare> getResultCompares() {
        return this.resultCompares;
    }

    public void setResultCompares(List<ResultCompare> resultCompares, Testable owner) {
        for (ResultCompare compare : resultCompares) {
            compare.setOwner(owner);
        }
        this.resultCompares = resultCompares;
    }

    public void doCancel() {
    }

    private void addResultCompares(Element results, Testable owner) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        NodeList children = results.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            Element child = (Element)childNode;
            String nodeName = child.getNodeName();
            TestType resultTestType = TypeFactory.getInstance().getType(nodeName);
            ResultCompare resultCompare = (ResultCompare)resultTestType.newInstance();
            resultCompare.setOwner(owner);
            if (child.hasAttribute("name")) {
                resultCompare.setName(child.getAttribute("name"));
            } else {
                resultCompare.setName(resultCompare.getClass().getName());
            }
            resultCompare.init(child);
            this.resultCompares.add(resultCompare);
        }
    }

    public void toXml(Element parent) {
        Element compare = parent.getOwnerDocument().createElement("compare");
        if (this.name != null && this.name.length() > 0) {
            compare.setAttribute("name", this.name);
        }
        for (ResultCompare test : this.resultCompares) {
            test.toXml(compare);
        }
        parent.appendChild(compare);
    }

    public void clear(Map<String, String> properties) {
        this.clearReferenceAndTestData();
        for (ResultCompare compare : this.resultCompares) {
            compare.clear(properties);
        }
    }

    public boolean hasIgnoredDifferences() {
        boolean noIgnoredDifferences = true;
        int length = this.resultCompares.size();
        for (int i = 0; i < length && noIgnoredDifferences; ++i) {
            noIgnoredDifferences = !this.resultCompares.get(i).hasIgnoredDifferences();
        }
        return !noIgnoredDifferences;
    }

    public void removeReferenceData(Map<String, String> runProperties) {
        this.referenceData = null;
        this.testData = null;
        for (ResultCompare resultCompare : this.resultCompares) {
            resultCompare.removeReferenceData(runProperties);
        }
    }
}

