/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETestSuiteTemplate;
import ch.e2e.test.E2ETestSuiteTemplateFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.TreeSet;

public class LibrariesRoot
extends ArrayList<TreeTestSuite>
implements TreePathElement {
    private static File librariesFolder;
    private File rootFolder;
    private LibrariesFileFilter librariesFileFilter = new LibrariesFileFilter();

    public static File getLibrariesFolder() {
        return librariesFolder;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(File rootFolder) {
        if (!(rootFolder == null || this.rootFolder != null && this.rootFolder.equals(rootFolder))) {
            this.rootFolder = rootFolder;
        }
    }

    public void reload() {
        this.clear();
        librariesFolder = new File(this.rootFolder, "regressiontest/testsuite/libraries");
        File[] libraryFiles = FileUtilities.getFileList((File)librariesFolder, (FileFilter)((Object)this.librariesFileFilter));
        TreeSet<Library> sortedSet = new TreeSet<Library>();
        for (File libraryFile : libraryFiles) {
            try {
                libraryFile = new File(libraryFile, "library.xml");
                E2ETestSuiteTemplate template = E2ETestSuiteTemplateFactory.getInstance().getTemplate(libraryFile, false);
                if (!template.isLibrary()) continue;
                Library library = new Library(template, null, false);
                library.setTreeParent(this);
                sortedSet.add(library);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addAll(sortedSet);
    }

    public Object getChild(int index) {
        return this.get(index);
    }

    public int getChildCount() {
        return this.size();
    }

    public int getIndexOfChild(Object child) {
        return this.indexOf(child);
    }

    public boolean isLeaf() {
        return this.size() == 0;
    }

    public int getType() {
        return 0;
    }

    @Override
    public Object getTreeParent() {
        return null;
    }

    @Override
    public boolean isDescendant(TreePathElement element) {
        if (element != null) {
            Object parent = element.getTreeParent();
            while (parent instanceof TreePathElement) {
                if (this.equals(parent)) {
                    return true;
                }
                parent = ((TreePathElement)parent).getTreeParent();
            }
        }
        return false;
    }

    @Override
    public boolean add(TreeTestSuite testSuite) {
        testSuite.setTreeParent(this);
        TreeSet<TreeTestSuite> sortedSet = new TreeSet<TreeTestSuite>(this);
        sortedSet.add(testSuite);
        this.clear();
        return this.addAll(sortedSet);
    }

    @Override
    public String toString() {
        return "Libraries";
    }

    public static boolean isInLibraryTree(TreePathElement test) {
        boolean result = false;
        Object parent = test.getTreeParent();
        while (parent != null && !result) {
            if (parent instanceof LibrariesRoot) {
                result = true;
                continue;
            }
            parent = ((TreeTestSuite)parent).getTreeParent();
        }
        return result;
    }

    private class LibrariesFileFilter
    extends E2EFileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory() && new File(pathname, "library.xml").exists();
        }

        public String getDescription() {
            return "";
        }

        public String getDefaultExtension() {
            return "xml";
        }
    }
}

