/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AbstractOptionPanel;
import ch.e2e.test.options.Option;
import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.JTextField;

public abstract class TextFieldOptionPane<T, U extends Option>
extends AbstractOptionPanel<T, U> {
    private Color editableForeground;
    private Color editableBackground;
    private Color readOnlyForeground;
    private Color readOnlyBackground;

    protected abstract JTextField getTextField();

    protected TextFieldOptionPane() {
    }

    protected TextFieldOptionPane(LayoutManager layout) {
        super(layout);
    }

    @Override
    public void setChanged(boolean changed) {
        this.checkTextFieldColors();
        super.setChanged(changed);
        if (!changed && this.getOption().isInherited()) {
            this.getTextField().setFont(this.getTextField().getFont().deriveFont(2));
            this.getTextField().setForeground(Color.DARK_GRAY);
        } else {
            this.getTextField().setFont(this.getTextField().getFont().deriveFont(0));
            this.getTextField().setForeground(this.getTextField().isEditable() ? this.editableForeground : this.readOnlyForeground);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getTextField().getText().isEmpty();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.getTextField().setEditable(!readOnly);
    }

    @Override
    public void setOption(U option) {
        this.setBackground();
    }

    protected void inputChanged() {
        this.checkTextFieldColors();
        this.fireOptionInputChanged();
        this.getTextField().setFont(this.getTextField().getFont().deriveFont(0));
        this.getTextField().setForeground(this.getTextField().isEditable() ? this.editableForeground : this.readOnlyForeground);
        this.setChanged(true);
        this.setBackground();
    }

    private void setBackground() {
        this.checkTextFieldColors();
        if (this.isEmpty() && this.getOption().isRequired() && !this.isIgnoreRequired()) {
            this.getTextField().setBackground(new Color(255, 224, 196));
        } else {
            this.getTextField().setBackground(this.getTextField().isEditable() ? this.editableBackground : this.readOnlyBackground);
        }
    }

    private void checkTextFieldColors() {
        if (this.editableBackground == null) {
            boolean editable = this.getTextField().isEditable();
            this.getTextField().setEditable(true);
            this.editableBackground = this.getTextField().getBackground();
            this.editableForeground = this.getTextField().getForeground();
            this.getTextField().setEditable(false);
            this.readOnlyBackground = this.getTextField().getBackground();
            this.readOnlyForeground = this.getTextField().getForeground();
            this.getTextField().setEditable(editable);
        }
    }
}

