/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.regtest.event.CompareTestActionEvent;
import ch.e2e.builder.regtest.event.CompareTestActionListener;
import ch.e2e.builder.regtest.event.NameChangedEvent;
import ch.e2e.builder.regtest.event.NameChangedListener;
import ch.e2e.builder.regtest.gui.GeneralTestcasePreferencesPanel;
import ch.e2e.builder.regtest.gui.TestPreferencesPanel;
import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.builder.regtest.gui.swing.OptionPanel;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.Utilities;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TestcasePreferencesDialog
extends E2EBuilderDialog
implements CompareTestActionListener,
NameChangedListener,
OptionInputChangedListener {
    private static TestcasePreferencesDialog dialog;
    private JideTabbedPane tabs;
    private GeneralTestcasePreferencesPanel generalOptions;
    private OptionPanel testActionOptions;
    private E2EBuilderModule module;
    private ArrayList<ResultCompare> addedCompares;
    private ArrayList<ResultCompare> removedCompares;
    private ArrayList<TestPreferencesPanel> testPanels;
    private HashMap<String, OptionComponent> options;
    private Testcase test;
    private boolean setDefaultValue;
    private boolean selectNameField;

    private TestcasePreferencesDialog(E2EBuilderModule module) {
        super(module.getTranslation("testcase.preferences.dialog.title"), module.getTranslation("testcase.preferences.dialog.internaltitle"), module.getTranslation("testcase.preferences.dialog.subtitle"), 3);
        this.module = module;
        this.createGui(module);
        this.addedCompares = new ArrayList();
        this.removedCompares = new ArrayList();
        this.generalOptions.setCompareTestActionListener(this);
    }

    public static TestcasePreferencesDialog getInstance(E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new TestcasePreferencesDialog(module);
        }
        return dialog;
    }

    public boolean rename(Testcase test, boolean isNew) {
        String libraryOuput = this.initialize(test, isNew);
        this.tabs.setSelectedComponent((Component)this.testActionOptions);
        this.selectNameField = true;
        return this.finalizeDialog(test, isNew, libraryOuput);
    }

    public boolean editPreferences(Testcase test, boolean isNew) {
        String libraryOuput = this.initialize(test, isNew);
        return this.finalizeDialog(test, isNew, libraryOuput);
    }

    private boolean finalizeDialog(Testcase test, boolean isNew, String libraryOuput) {
        boolean result = false;
        if (dialog.showDialog(true) == 1) {
            this.testActionOptions.persist(isNew);
            for (TestPreferencesPanel testPanel : this.testPanels) {
                testPanel.persist(isNew);
            }
            this.generalOptions.persist();
            Utilities.insertProperties((E2ETestcase)test);
            result = true;
        }
        if (LibrariesRoot.isInLibraryTree(test)) {
            test.getParent().getProperties().put("library.output.folder", libraryOuput);
        }
        return result;
    }

    private String initialize(Testcase test, boolean isNew) {
        boolean readOnly = !test.canWrite() || test.isInLibrary() && !LibrariesRoot.isInLibraryTree(test);
        this.setDefaultValue = isNew || !LibrariesRoot.isInLibraryTree(test);
        this.test = test;
        this.clearOptionListeners();
        String folder = ((TreeTestSuite)test.getParent()).getPath();
        File projectHome = new File(System.getProperty("ch.e2e.builder.base.home"));
        test.setReferenceFolder(new File(projectHome, "regressiontest/reference/" + folder));
        File outputFolder = new File(projectHome, "regressiontest/.$output/" + folder);
        test.setTestFolder(outputFolder);
        test.setSourceFolder(new File(projectHome, "regressiontest/source/" + folder));
        String libraryOuput = null;
        if (LibrariesRoot.isInLibraryTree(test)) {
            libraryOuput = test.getParent().getProperties().get("library.output.folder");
            test.getParent().getProperties().put("library.output.folder", outputFolder.getAbsolutePath());
        }
        Utilities.mergeOptions((OptionContainer)test.getParent().getInheritedOptions(test.getTest().getType(), true), (OptionContainer)test.getTest());
        Utilities.replaceProperties((E2ETestcase)test);
        this.setProjectHomeAsDefaultStartFolder(projectHome, test);
        this.generalOptions.setTestcase(test, readOnly);
        this.options = this.testActionOptions.setOptions(test.getTest().getOptions().values(), readOnly, this.setDefaultValue);
        for (String option : this.options.keySet()) {
            OptionComponent optionComponent;
            if (!option.equals("service.test.type") || (optionComponent = this.options.get(option)).getValue() != null) continue;
            optionComponent.setValue("E2E xUML Service");
        }
        while (this.tabs.getTabCount() > 2) {
            this.tabs.removeTabAt(2);
        }
        this.testPanels = new ArrayList();
        if (test.getResult() != null) {
            for (ResultCompare compare : test.getResult().getResultCompares()) {
                OptionContainer inheritedOptions = test.getParent().getInheritedOptions(compare.getType(), true);
                Utilities.mergeOptions((OptionContainer)inheritedOptions, (OptionContainer)compare);
                TestPreferencesPanel testPanel = this.createTestPanel(compare);
                this.options.putAll(testPanel.setResultCompare(compare, readOnly, this.setDefaultValue));
            }
        }
        this.tabs.setSelectedComponent((Component)this.generalOptions);
        this.addOptionDependencies(this.options);
        this.checkOkButton(readOnly);
        return libraryOuput;
    }

    private void setProjectHomeAsDefaultStartFolder(File projectHome, Testcase test) {
        this.setDefaultStartFolder(projectHome, test.getTest().getOptions().values());
        this.setDefaultStartFolder(projectHome, test.getTest().getAdvancedOptions().values());
        for (ResultCompare compare : test.getTest().getResult().getResultCompares()) {
            this.setDefaultStartFolder(projectHome, compare.getOptions().values());
            this.setDefaultStartFolder(projectHome, compare.getAdvancedOptions().values());
        }
    }

    private void setDefaultStartFolder(File projectHome, Collection<Option> options) {
        for (Option option : options) {
            if (!(option instanceof FileOption) || ((FileOption)option).getDefaultStartFolder() != null) continue;
            ((FileOption)option).setDefaultStartFolder(projectHome);
        }
    }

    private void clearOptionListeners() {
        if (this.options != null) {
            if (this.options.containsKey("key.option.test.name")) {
                this.options.get("key.option.test.name").removeOptionChangedListener(this.generalOptions);
            }
            for (OptionComponent component : this.options.values()) {
                component.removeOptionChangedListener(this);
                Object option = component.getOption();
                OptionComponent optionComponent = this.options.get(option.getKey());
                List dependencies = option.getDependencies();
                for (String dependency : dependencies) {
                    if (!this.options.containsKey(dependency)) continue;
                    OptionComponent dependencyComponent = this.options.get(dependency);
                    dependencyComponent.removeOptionChangedListener(optionComponent);
                }
            }
        }
    }

    private void addOptionDependencies(HashMap<String, OptionComponent> addedOptions) {
        if (addedOptions.containsKey("key.option.test.name")) {
            addedOptions.get("key.option.test.name").addOptionChangedListener(this.generalOptions);
        }
        for (OptionComponent component : addedOptions.values()) {
            component.addOptionChangedListener(this);
            Object option = component.getOption();
            OptionComponent optionComponent = addedOptions.get(option.getKey());
            List dependencies = option.getDependencies();
            for (String dependency : dependencies) {
                if (!this.options.containsKey(dependency)) continue;
                OptionComponent dependencyComponent = this.options.get(dependency);
                dependencyComponent.addOptionChangedListener(optionComponent);
                optionComponent.optionChanged(new OptionInputChangedEvent(this, dependency, dependencyComponent.getValue()));
            }
        }
    }

    private void createGui(E2EBuilderModule module) {
        this.setLayout(new BorderLayout());
        this.tabs = new JideTabbedPane();
        this.generalOptions = new GeneralTestcasePreferencesPanel(module);
        this.tabs.addTab(module.getTranslation("testcase.preferences.dialog.tabtitle.general"), (Component)this.generalOptions);
        this.testActionOptions = new OptionPanel((Dialog)((Object)this), E2EBuilder.getInstance().getE2EBuilderLogo(), E2EBuilderTranslator.getTranslator((String)module.getName()));
        this.testActionOptions.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (TestcasePreferencesDialog.this.selectNameField) {
                    TestcasePreferencesDialog.this.testActionOptions.setNameFieldSelected();
                    TestcasePreferencesDialog.this.selectNameField = false;
                }
            }
        });
        this.tabs.addTab(module.getTranslation("testcase.preferences.dialog.tabtitle.test.action"), (Component)this.testActionOptions);
        this.add((Component)this.tabs, "Center");
    }

    @Override
    public void compareTestAdded(CompareTestActionEvent event) {
        ResultCompare compare = event.getCompare();
        this.addedCompares.add(compare);
        this.removedCompares.remove(compare);
        this.test.getTest().prepareCompareType(compare);
        TestPreferencesPanel testPanel = this.createTestPanel(compare);
        HashMap<String, OptionComponent> result = testPanel.setResultCompare(compare, false, this.setDefaultValue);
        this.addOptionDependencies(result);
        this.tabs.setSelectedComponent((Component)testPanel);
    }

    private TestPreferencesPanel createTestPanel(ResultCompare compare) {
        TestPreferencesPanel testpanel = new TestPreferencesPanel((Dialog)((Object)this), this.module);
        this.tabs.addTab(compare.getName(), (Component)testpanel);
        this.testPanels.add(testpanel);
        testpanel.setNameChangedListener(this);
        return testpanel;
    }

    private void checkOkButton(boolean readOnly) {
        if (LibrariesRoot.isInLibraryTree(this.test)) {
            this.setOkButtonEnabled(true);
        } else {
            boolean enabled = !readOnly;
            for (OptionComponent component : this.options.values()) {
                if (!component.getOption().isRequired() || !component.isEmpty()) continue;
                enabled = false;
                break;
            }
            this.setOkButtonEnabled(enabled);
        }
    }

    @Override
    public void compareTestRemoved(CompareTestActionEvent event) {
        ResultCompare compare = event.getCompare();
        this.removedCompares.add(compare);
        this.addedCompares.remove(compare);
        this.tabs.removeTabAt(this.tabs.indexOfTab(compare.getName()));
    }

    @Override
    public void nameChanged(NameChangedEvent event) {
        int index = this.tabs.indexOfComponent((Component)event.getSource());
        if (index != -1) {
            this.tabs.setTitleAt(index, event.getNewName());
        }
    }

    @Override
    public void optionChanged(OptionInputChangedEvent event) {
        this.checkOkButton(false);
    }
}

